/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpHeader;
import swim.http.HttpWriter;

final class HttpHeaderWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final HttpHeader header;
    final Writer<?, ?> part;
    final int step;

    HttpHeaderWriter(HttpWriter http, HttpHeader header, Writer<?, ?> part, int step) {
        this.http = http;
        this.header = header;
        this.part = part;
        this.step = step;
    }

    HttpHeaderWriter(HttpWriter http, HttpHeader header) {
        this(http, header, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return HttpHeaderWriter.write(output, this.http, this.header, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, HttpHeader header, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(output, header.name()) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(58);
            if (header.isBlank()) {
                return Writer.done();
            }
            step = 3;
        }
        if (step == 3 && output.isCont()) {
            output = output.write(32);
            step = 4;
        }
        if (step == 4) {
            if ((part = part == null ? http.writeHeaderValue(output, header) : part.pull(output)).isDone()) {
                return Writer.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new HttpHeaderWriter(http, header, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, HttpHeader header) {
        return HttpHeaderWriter.write(output, http, header, null, 1);
    }
}

