/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpBody;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpMethod;
import swim.http.HttpPayload;
import swim.http.HttpVersion;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.uri.Uri;
import swim.util.Murmur3;

public final class HttpRequest<T>
extends HttpMessage<T>
implements Debug {
    final HttpMethod method;
    final Uri uri;
    final HttpVersion version;
    final FingerTrieSeq<HttpHeader> headers;
    final HttpPayload<T> payload;
    private static int hashSeed;

    HttpRequest(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers, HttpPayload<T> payload) {
        this.method = method;
        this.uri = uri;
        this.version = version;
        this.headers = headers;
        this.payload = payload;
    }

    HttpRequest(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers) {
        this(method, uri, version, headers, HttpPayload.empty());
    }

    public HttpMethod method() {
        return this.method;
    }

    public HttpRequest<T> method(HttpMethod method) {
        return HttpRequest.create(method, this.uri, this.version, this.headers, this.payload);
    }

    public Uri uri() {
        return this.uri;
    }

    public HttpRequest<T> uri(Uri uri) {
        return HttpRequest.create(this.method, uri, this.version, this.headers, this.payload);
    }

    @Override
    public HttpVersion version() {
        return this.version;
    }

    public HttpRequest<T> version(HttpVersion version) {
        return HttpRequest.create(this.method, this.uri, version, this.headers, this.payload);
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        return this.headers;
    }

    @Override
    public HttpRequest<T> headers(FingerTrieSeq<HttpHeader> headers) {
        return HttpRequest.create(this.method, this.uri, this.version, headers, this.payload);
    }

    @Override
    public HttpRequest<T> headers(HttpHeader ... headers) {
        return this.headers(FingerTrieSeq.of((Object[])headers));
    }

    @Override
    public HttpRequest<T> appendedHeaders(FingerTrieSeq<HttpHeader> newHeaders) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq headers = oldHeaders.appended(newHeaders);
        if (oldHeaders != headers) {
            return HttpRequest.create(this.method, this.uri, this.version, (FingerTrieSeq<HttpHeader>)headers, this.payload);
        }
        return this;
    }

    @Override
    public HttpRequest<T> appendedHeaders(HttpHeader ... newHeaders) {
        return this.appendedHeaders(FingerTrieSeq.of((Object[])newHeaders));
    }

    @Override
    public HttpRequest<T> appendedHeader(HttpHeader newHeader) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq headers = oldHeaders.appended((Object)newHeader);
        if (oldHeaders != headers) {
            return HttpRequest.create(this.method, this.uri, this.version, (FingerTrieSeq<HttpHeader>)headers, this.payload);
        }
        return this;
    }

    @Override
    public HttpRequest<T> updatedHeaders(FingerTrieSeq<HttpHeader> newHeaders) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq<HttpHeader> headers = HttpMessage.updatedHeaders(oldHeaders, newHeaders);
        if (oldHeaders != headers) {
            return HttpRequest.create(this.method, this.uri, this.version, headers, this.payload);
        }
        return this;
    }

    @Override
    public HttpRequest<T> updatedHeaders(HttpHeader ... newHeaders) {
        return this.updatedHeaders(FingerTrieSeq.of((Object[])newHeaders));
    }

    @Override
    public HttpRequest<T> updatedHeader(HttpHeader newHeader) {
        FingerTrieSeq<HttpHeader> oldHeaders = this.headers;
        FingerTrieSeq<HttpHeader> headers = HttpMessage.updatedHeaders(oldHeaders, newHeader);
        if (oldHeaders != headers) {
            return HttpRequest.create(this.method, this.uri, this.version, headers, this.payload);
        }
        return this;
    }

    @Override
    public HttpPayload<T> payload() {
        return this.payload;
    }

    @Override
    public <T2> HttpRequest<T2> payload(HttpPayload<T2> payload) {
        return HttpRequest.create(this.method, this.uri, this.version, this.headers, payload);
    }

    @Override
    public <T2> HttpRequest<T2> content(HttpPayload<T2> payload) {
        FingerTrieSeq<HttpHeader> headers = HttpMessage.updatedHeaders(this.headers, payload.headers());
        return HttpRequest.create(this.method, this.uri, this.version, headers, payload);
    }

    public HttpRequest<String> body(String content, MediaType mediaType) {
        return this.content(HttpBody.create(content, mediaType));
    }

    public HttpRequest<String> body(String content) {
        return this.content(HttpBody.create(content));
    }

    @Override
    public <T2> Decoder<HttpRequest<T2>> payloadDecoder(Decoder<T2> contentDecoder) {
        return super.payloadDecoder(contentDecoder);
    }

    @Override
    public Encoder<?, HttpRequest<T>> httpEncoder(HttpWriter http) {
        return super.httpEncoder(http);
    }

    @Override
    public Encoder<?, HttpRequest<T>> httpEncoder() {
        return super.httpEncoder();
    }

    @Override
    public Encoder<?, HttpRequest<T>> encodeHttp(OutputBuffer<?> output, HttpWriter http) {
        return super.encodeHttp(output, http);
    }

    @Override
    public Encoder<?, HttpRequest<T>> encodeHttp(OutputBuffer<?> output) {
        return super.encodeHttp(output);
    }

    public Writer<?, HttpRequest<T>> httpWriter(HttpWriter http) {
        return http.requestWriter(this);
    }

    public Writer<?, HttpRequest<T>> httpWriter() {
        return this.httpWriter(Http.standardWriter());
    }

    public Writer<?, HttpRequest<T>> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeRequest(output, this);
    }

    public Writer<?, HttpRequest<T>> writeHttp(Output<?> output) {
        return this.writeHttp(output, Http.standardWriter());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpRequest) {
            HttpRequest that = (HttpRequest)other;
            return this.method.equals(that.method) && this.uri.equals((Object)that.uri) && this.version.equals(that.version) && this.headers.equals(that.headers) && this.payload.equals(that.payload);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpRequest.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.method.hashCode()), (int)this.uri.hashCode()), (int)this.version.hashCode()), (int)this.headers.hashCode()), (int)this.payload.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HttpRequest").write(46).write("create").write(40).debug((Object)this.method).write(", ").debug((Object)this.uri).write(", ").debug((Object)this.version);
        for (HttpHeader header : this.headers) {
            output = output.write(", ").debug((Object)header);
        }
        output = output.write(41);
        if (this.payload.isDefined()) {
            output = output.write(46).write("payload").write(40).debug(this.payload).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> HttpRequest<T> create(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers, HttpPayload<T> payload) {
        return new HttpRequest<T>(method, uri, version, headers, payload);
    }

    public static <T> HttpRequest<T> create(HttpMethod method, Uri uri, HttpVersion version, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(method, uri, version, headers);
    }

    public static <T> HttpRequest<T> create(HttpMethod method, Uri uri, HttpVersion version, HttpHeader ... headers) {
        return new HttpRequest<T>(method, uri, version, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> create(HttpMethod method, Uri uri, HttpVersion version) {
        return new HttpRequest<T>(method, uri, version, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
    }

    public static <T> HttpRequest<T> get(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.GET, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> get(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.GET, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> head(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.HEAD, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> head(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.HEAD, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> post(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.POST, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> post(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.POST, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> put(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.PUT, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> put(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.PUT, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> delete(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.DELETE, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> delete(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.DELETE, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> connect(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.CONNECT, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> connect(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.CONNECT, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> options(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.OPTIONS, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> options(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.OPTIONS, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> trace(Uri uri, FingerTrieSeq<HttpHeader> headers) {
        return new HttpRequest<T>(HttpMethod.TRACE, uri, HttpVersion.HTTP_1_1, headers);
    }

    public static <T> HttpRequest<T> trace(Uri uri, HttpHeader ... headers) {
        return new HttpRequest<T>(HttpMethod.TRACE, uri, HttpVersion.HTTP_1_1, (FingerTrieSeq<HttpHeader>)FingerTrieSeq.of((Object[])headers));
    }

    public static <T> HttpRequest<T> parseHttp(String string) {
        return Http.standardParser().parseRequestString(string);
    }
}

