/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.ParserException;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpHeader;
import swim.http.HttpMethod;
import swim.http.HttpParser;
import swim.http.HttpRequest;
import swim.http.HttpVersion;
import swim.uri.Uri;
import swim.util.Builder;

final class HttpRequestParser<T>
extends Parser<HttpRequest<T>> {
    final HttpParser http;
    final Parser<HttpMethod> methodParser;
    final StringBuilder uriBuilder;
    final Parser<HttpVersion> versionParser;
    final Parser<? extends HttpHeader> headerParser;
    final Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers;
    final int step;

    HttpRequestParser(HttpParser http, Parser<HttpMethod> methodParser, StringBuilder uriBuilder, Parser<HttpVersion> versionParser, Parser<? extends HttpHeader> headerParser, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        this.http = http;
        this.methodParser = methodParser;
        this.uriBuilder = uriBuilder;
        this.versionParser = versionParser;
        this.headerParser = headerParser;
        this.headers = headers;
        this.step = step;
    }

    HttpRequestParser(HttpParser http) {
        this(http, null, null, null, null, null, 1);
    }

    public Parser<HttpRequest<T>> feed(Input input) {
        return HttpRequestParser.parse(input, this.http, this.methodParser, this.uriBuilder, this.versionParser, this.headerParser, this.headers, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> Parser<HttpRequest<T>> parse(Input input, HttpParser http, Parser<HttpMethod> methodParser, StringBuilder uriBuilder, Parser<HttpVersion> versionParser22222, Parser<? extends HttpHeader> headerParser32222, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        void versionParser22222;
        void headerParser32222;
        block58: {
            int c = 0;
            if (step == 1) {
                if (methodParser == null) {
                    if (input.isDone()) {
                        return HttpRequestParser.done();
                    }
                    methodParser = http.parseMethod(input);
                } else {
                    methodParser = methodParser.feed(input);
                }
                if (methodParser.isDone()) {
                    step = 2;
                } else if (methodParser.isError()) {
                    return methodParser.asError();
                }
            }
            if (step == 2) {
                if (input.isCont() && input.head() == 32) {
                    input = input.step();
                    step = 3;
                } else if (!input.isEmpty()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"space", (Input)input));
                }
            }
            if (step == 3) {
                if (uriBuilder == null) {
                    uriBuilder = new StringBuilder();
                }
                while (input.isCont() && (c = input.head()) != 32) {
                    input = input.step();
                    uriBuilder.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    step = 4;
                }
            }
            if (step == 4) {
                if (input.isCont() && input.head() == 32) {
                    input = input.step();
                    step = 5;
                } else if (!input.isEmpty()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"space", (Input)input));
                }
            }
            if (step == 5) {
                void versionParser22222;
                if (versionParser22222 == null) {
                    Parser<HttpVersion> versionParser22222 = http.parseVersion(input);
                } else {
                    Object versionParser22222;
                    Parser versionParser22222 = versionParser22222.feed(input);
                }
                if (versionParser22222.isDone()) {
                    step = 6;
                } else if (versionParser22222.isError()) {
                    return versionParser22222.asError();
                }
            }
            if (step == 6) {
                if (input.isCont() && input.head() == 13) {
                    input = input.step();
                    step = 7;
                } else if (!input.isEmpty()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                }
            }
            if (step == 7) {
                if (input.isCont() && input.head() == 10) {
                    input = input.step();
                    step = 8;
                } else if (!input.isEmpty()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
                }
            }
            while (true) {
                block59: {
                    block60: {
                        if (step != 8) break block59;
                        if (!input.isCont()) break block60;
                        c = input.head();
                        if (Http.isTokenChar(c)) {
                            step = 9;
                            break block59;
                        } else {
                            if (Http.isSpace(c)) {
                                return Parser.error((Diagnostic)Diagnostic.message((String)"unsupported header line extension", (Input)input));
                            }
                            if (c != 13) {
                                return Parser.error((Diagnostic)Diagnostic.expected((String)"HTTP header", (Input)input));
                            }
                            input = input.step();
                            step = 12;
                            break block58;
                        }
                    }
                    if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((String)"HTTP header", (Input)input));
                    }
                }
                if (step == 9) {
                    void headerParser32222;
                    if (headerParser32222 == null) {
                        Parser<HttpHeader> headerParser32222 = http.parseHeader(input);
                    } else {
                        void headerParser32222;
                        Parser headerParser32222 = headerParser32222.feed(input);
                    }
                    if (headerParser32222.isDone()) {
                        step = 10;
                    } else if (headerParser32222.isError()) {
                        return headerParser32222.asError();
                    }
                }
                if (step == 10) {
                    if (input.isCont() && input.head() == 13) {
                        input = input.step();
                        step = 11;
                    } else if (!input.isEmpty()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                    }
                }
                if (step != 11) break block58;
                if (!input.isCont() || input.head() != 10) break;
                if (headers == null) {
                    headers = FingerTrieSeq.builder();
                }
                headers.add((Object)((HttpHeader)headerParser32222.bind()));
                Object headerParser32222 = null;
                input = input.step();
                step = 8;
            }
            if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (step == 12) {
            if (input.isCont() && input.head() == 10) {
                Uri requestUri;
                input = input.step();
                try {
                    requestUri = Uri.parse((String)uriBuilder.toString());
                }
                catch (ParserException cause) {
                    return Parser.error((Throwable)cause);
                }
                if (headers == null) {
                    HttpRequest request = http.request((HttpMethod)methodParser.bind(), requestUri, (HttpVersion)versionParser22222.bind(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
                    return Parser.done(request);
                }
                HttpRequest request = http.request((HttpMethod)methodParser.bind(), requestUri, (HttpVersion)versionParser22222.bind(), (FingerTrieSeq<HttpHeader>)((FingerTrieSeq)headers.bind()));
                return Parser.done(request);
            }
            if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new HttpRequestParser<T>(http, methodParser, uriBuilder, (Parser<HttpVersion>)versionParser22222, (Parser<? extends HttpHeader>)headerParser32222, (Builder<HttpHeader, FingerTrieSeq<HttpHeader>>)headers, step);
    }

    static <T> Parser<HttpRequest<T>> parse(Input input, HttpParser http) {
        return HttpRequestParser.parse(input, http, null, null, null, null, null, 1);
    }
}

