/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpResponse;
import swim.http.HttpStatus;
import swim.http.HttpVersion;
import swim.util.Builder;

final class HttpResponseParser<T>
extends Parser<HttpResponse<T>> {
    final HttpParser http;
    final Parser<HttpVersion> versionParser;
    final Parser<HttpStatus> statusParser;
    final Parser<? extends HttpHeader> headerParser;
    final Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers;
    final int step;

    HttpResponseParser(HttpParser http, Parser<HttpVersion> versionParser, Parser<HttpStatus> statusParser, Parser<? extends HttpHeader> headerParser, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        this.http = http;
        this.versionParser = versionParser;
        this.statusParser = statusParser;
        this.headerParser = headerParser;
        this.headers = headers;
        this.step = step;
    }

    HttpResponseParser(HttpParser http) {
        this(http, null, null, null, null, 1);
    }

    public Parser<HttpResponse<T>> feed(Input input) {
        return HttpResponseParser.parse(input, this.http, this.versionParser, this.statusParser, this.headerParser, this.headers, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <T> Parser<HttpResponse<T>> parse(Input input, HttpParser http, Parser<HttpVersion> versionParser, Parser<HttpStatus> statusParser22222, Parser<? extends HttpHeader> headerParser32222, Builder<HttpHeader, FingerTrieSeq<HttpHeader>> headers, int step) {
        void statusParser22222;
        void headerParser32222;
        block49: {
            int c = 0;
            if (step == 1) {
                if (versionParser == null) {
                    if (input.isDone()) {
                        return Parser.done();
                    }
                    versionParser = http.parseVersion(input);
                } else {
                    versionParser = versionParser.feed(input);
                }
                if (versionParser.isDone()) {
                    step = 2;
                } else if (versionParser.isError()) {
                    return versionParser.asError();
                }
            }
            if (step == 2) {
                if (input.isCont() && input.head() == 32) {
                    input = input.step();
                    step = 3;
                } else if (!input.isEmpty()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"space", (Input)input));
                }
            }
            if (step == 3) {
                void statusParser22222;
                if (statusParser22222 == null) {
                    Parser<HttpStatus> statusParser22222 = http.parseStatus(input);
                } else {
                    Object statusParser22222;
                    Parser statusParser22222 = statusParser22222.feed(input);
                }
                if (statusParser22222.isDone()) {
                    step = 4;
                } else if (statusParser22222.isError()) {
                    return statusParser22222.asError();
                }
            }
            if (step == 4) {
                if (input.isCont() && input.head() == 13) {
                    input = input.step();
                    step = 5;
                } else if (!input.isEmpty()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                }
            }
            if (step == 5) {
                if (input.isCont() && input.head() == 10) {
                    input = input.step();
                    step = 6;
                } else if (!input.isEmpty()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
                }
            }
            while (true) {
                if (step == 6) {
                    if (input.isCont()) {
                        c = input.head();
                        if (Http.isTokenChar(c)) {
                            step = 7;
                        } else {
                            if (Http.isSpace(c)) {
                                return Parser.error((Diagnostic)Diagnostic.message((String)"unsupported header line extension", (Input)input));
                            }
                            if (c != 13) return Parser.error((Diagnostic)Diagnostic.expected((String)"HTTP header", (Input)input));
                            input = input.step();
                            step = 10;
                        }
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((String)"HTTP header", (Input)input));
                    }
                }
                if (step == 7) {
                    void headerParser32222;
                    if (headerParser32222 == null) {
                        Parser<HttpHeader> headerParser32222 = http.parseHeader(input);
                    } else {
                        void headerParser32222;
                        Parser headerParser32222 = headerParser32222.feed(input);
                    }
                    if (headerParser32222.isDone()) {
                        step = 8;
                    } else if (headerParser32222.isError()) {
                        return headerParser32222.asError();
                    }
                }
                if (step == 8) {
                    if (input.isCont() && input.head() == 13) {
                        input = input.step();
                        step = 9;
                    } else if (!input.isEmpty()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((String)"carriage return", (Input)input));
                    }
                }
                if (step != 9) break block49;
                if (!input.isCont() || input.head() != 10) break;
                if (headers == null) {
                    headers = FingerTrieSeq.builder();
                }
                headers.add((Object)((HttpHeader)headerParser32222.bind()));
                Object headerParser32222 = null;
                input = input.step();
                step = 6;
            }
            if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (step == 10) {
            if (input.isCont() && input.head() == 10) {
                input = input.step();
                if (headers == null) {
                    HttpResponse response = http.response((HttpVersion)versionParser.bind(), (HttpStatus)statusParser22222.bind(), (FingerTrieSeq<HttpHeader>)FingerTrieSeq.empty());
                    return Parser.done(response);
                }
                HttpResponse response = http.response((HttpVersion)versionParser.bind(), (HttpStatus)statusParser22222.bind(), (FingerTrieSeq<HttpHeader>)((FingerTrieSeq)headers.bind()));
                return Parser.done(response);
            }
            if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"line feed", (Input)input));
            }
        }
        if (!input.isError()) return new HttpResponseParser<T>(http, versionParser, (Parser<HttpStatus>)statusParser22222, (Parser<? extends HttpHeader>)headerParser32222, (Builder<HttpHeader, FingerTrieSeq<HttpHeader>>)headers, step);
        return Parser.error((Throwable)input.trap());
    }

    static <T> Parser<HttpResponse<T>> parse(Input input, HttpParser http) {
        return HttpResponseParser.parse(input, http, null, null, null, null, 1);
    }
}

