/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpPayload;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.TransferCoding;
import swim.util.Murmur3;

public final class HttpValue<T>
extends HttpPayload<T>
implements Debug {
    final T payloadValue;
    final MediaType mediaType;
    private static int hashSeed;

    HttpValue(T payloadValue, MediaType mediaType) {
        this.payloadValue = payloadValue;
        this.mediaType = mediaType;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public T get() {
        return this.payloadValue;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public FingerTrieSeq<TransferCoding> transferCodings() {
        return FingerTrieSeq.empty();
    }

    @Override
    public FingerTrieSeq<HttpHeader> headers() {
        return FingerTrieSeq.empty();
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> httpEncoder(HttpMessage<T2> message, HttpWriter http) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T2> Encoder<?, HttpMessage<T2>> encodeHttp(OutputBuffer<?> output, HttpMessage<T2> message, HttpWriter http) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpValue) {
            HttpValue that = (HttpValue)other;
            return (this.payloadValue == null ? that.payloadValue == null : this.payloadValue.equals(that.payloadValue)) && (this.mediaType == null ? that.mediaType == null : this.mediaType.equals(that.mediaType));
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpValue.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.payloadValue)), (int)Murmur3.hash((Object)this.mediaType)));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HttpValue").write(46).write("create").write(40).debug(this.payloadValue);
        if (this.mediaType != null) {
            output = output.write(", ").debug((Object)this.mediaType);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> HttpValue<T> create(T payloadValue, MediaType mediaType) {
        return new HttpValue<T>(payloadValue, mediaType);
    }

    public static <T> HttpValue<T> create(T payloadValue) {
        return new HttpValue<T>(payloadValue, null);
    }
}

