/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.HttpParser;
import swim.http.HttpVersion;

final class HttpVersionParser
extends Parser<HttpVersion> {
    final HttpParser http;
    final int major;
    final int minor;
    final int step;

    HttpVersionParser(HttpParser http, int major, int minor, int step) {
        this.http = http;
        this.major = major;
        this.minor = minor;
        this.step = step;
    }

    HttpVersionParser(HttpParser http) {
        this(http, 0, 0, 1);
    }

    public Parser<HttpVersion> feed(Input input) {
        return HttpVersionParser.parse(input, this.http, this.major, this.minor, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<HttpVersion> parse(Input input, HttpParser http, int major, int minor, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont() && input.head() == 72) {
                input = input.step();
                step = 2;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)72, (Input)input));
            }
        }
        if (step == 2) {
            if (input.isCont() && input.head() == 84) {
                input = input.step();
                step = 3;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)84, (Input)input));
            }
        }
        if (step == 3) {
            if (input.isCont() && input.head() == 84) {
                input = input.step();
                step = 4;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)84, (Input)input));
            }
        }
        if (step == 4) {
            if (input.isCont() && input.head() == 80) {
                input = input.step();
                step = 5;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)80, (Input)input));
            }
        }
        if (step == 5) {
            if (input.isCont() && input.head() == 47) {
                input = input.step();
                step = 6;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
            }
        }
        if (step == 6) {
            if (!input.isEmpty()) {
                c = input.head();
                if (!Base10.isDigit((int)c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"major version", (Input)input));
                input = input.step();
                major = Base10.decodeDigit((int)c);
                step = 7;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"major version", (Input)input));
            }
        }
        if (step == 7) {
            if (input.isCont() && input.head() == 46) {
                input = input.step();
                step = 8;
            } else if (!input.isEmpty()) {
                return Parser.error((Diagnostic)Diagnostic.expected((int)46, (Input)input));
            }
        }
        if (step == 8) {
            if (!input.isEmpty()) {
                c = input.head();
                if (!Base10.isDigit((int)c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"minor version", (Input)input));
                input = input.step();
                minor = Base10.decodeDigit((int)c);
                return Parser.done((Object)http.version(major, minor));
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"minor version", (Input)input));
            }
        }
        if (!input.isError()) return new HttpVersionParser(http, major, minor, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<HttpVersion> parse(Input input, HttpParser http) {
        return HttpVersionParser.parse(input, http, 0, 0, 1);
    }
}

