/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.LanguageRange;

final class LanguageRangeParser
extends Parser<LanguageRange> {
    final HttpParser http;
    final StringBuilder tagBuilder;
    final StringBuilder subtagBuilder;
    final Parser<Float> weightParser;
    final int step;

    LanguageRangeParser(HttpParser http, StringBuilder tagBuilder, StringBuilder subtagBuilder, Parser<Float> weightParser, int step) {
        this.http = http;
        this.tagBuilder = tagBuilder;
        this.subtagBuilder = subtagBuilder;
        this.weightParser = weightParser;
        this.step = step;
    }

    LanguageRangeParser(HttpParser http) {
        this(http, null, null, null, 1);
    }

    public Parser<LanguageRange> feed(Input input) {
        return LanguageRangeParser.parse(input, this.http, this.tagBuilder, this.subtagBuilder, this.weightParser, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<LanguageRange> parse(Input input, HttpParser http, StringBuilder tagBuilder, StringBuilder subtagBuilder, Parser<Float> weightParser2222, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (Http.isAlpha(c)) {
                    input = input.step();
                    if (tagBuilder == null) {
                        tagBuilder = new StringBuilder();
                    }
                    tagBuilder.appendCodePoint(c);
                    step = 2;
                } else {
                    if (c != 42) return Parser.error((Diagnostic)Diagnostic.expected((String)"language tag", (Input)input));
                    input = input.step();
                    tagBuilder = new StringBuilder("*");
                    step = 18;
                }
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"language tag", (Input)input));
            }
        }
        while (step >= 2 && step <= 8) {
            if (input.isCont()) {
                c = input.head();
                if (Http.isAlpha(c)) {
                    input = input.step();
                    tagBuilder.appendCodePoint(c);
                    ++step;
                    continue;
                }
                if (c == 45) {
                    input = input.step();
                    step = 9;
                    break;
                }
                step = 18;
                break;
            }
            if (!input.isDone()) break;
            step = 18;
            break;
        }
        if (step == 9) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isAlpha(c) && !Base10.isDigit((int)c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"language subtag", (Input)input));
                input = input.step();
                if (subtagBuilder == null) {
                    subtagBuilder = new StringBuilder();
                }
                subtagBuilder.appendCodePoint(c);
                step = 10;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"language subtag", (Input)input));
            }
        }
        while (step >= 10 && step <= 17) {
            if (input.isCont()) {
                c = input.head();
                if (Http.isAlpha(c) || Base10.isDigit((int)c)) {
                    input = input.step();
                    subtagBuilder.appendCodePoint(c);
                    ++step;
                    continue;
                }
                step = 18;
                break;
            }
            if (!input.isDone()) break;
            step = 18;
            break;
        }
        if (step == 18) {
            void weightParser2222;
            if (weightParser2222 == null) {
                Parser<Float> weightParser2222 = http.parseQValue(input);
            } else {
                Object weightParser2222;
                Parser weightParser2222 = weightParser2222.feed(input);
            }
            if (weightParser2222.isDone()) {
                Float qvalue = (Float)weightParser2222.bind();
                float q = qvalue != null ? qvalue.floatValue() : 1.0f;
                return Parser.done((Object)http.languageRange(tagBuilder.toString(), subtagBuilder != null ? subtagBuilder.toString() : null, q));
            }
            if (weightParser2222.isError()) {
                return weightParser2222.asError();
            }
        }
        if (!input.isError()) void weightParser2222;
        return new LanguageRangeParser(http, tagBuilder, subtagBuilder, (Parser<Float>)weightParser2222, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<LanguageRange> parse(Input input, HttpParser http) {
        return LanguageRangeParser.parse(input, http, null, null, null, 1);
    }
}

