/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;

final class LanguageRangeWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String tag;
    final String subtag;
    final float weight;
    final Writer<?, ?> part;
    final int step;

    LanguageRangeWriter(HttpWriter http, String tag, String subtag, float weight, Writer<?, ?> part, int step) {
        this.http = http;
        this.tag = tag;
        this.subtag = subtag;
        this.weight = weight;
        this.part = part;
        this.step = step;
    }

    LanguageRangeWriter(HttpWriter http, String tag, String subtag, float weight) {
        this(http, tag, subtag, weight, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return LanguageRangeWriter.write(output, this.http, this.tag, this.subtag, this.weight, this.part, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String tag, String subtag, float weight, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeField(output, tag) : part.pull(output)).isDone()) {
                part = null;
                if (subtag != null) {
                    step = 2;
                } else {
                    if (weight == 1.0f) return Writer.done();
                    step = 4;
                }
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(45);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? http.writeField(output, subtag) : part.pull(output)).isDone()) {
                part = null;
                if (weight == 1.0f) return Writer.done();
                step = 4;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4) {
            if ((part = part == null ? http.writeQValue(output, weight) : part.pull(output)).isDone()) {
                return Writer.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (!output.isError()) return new LanguageRangeWriter(http, tag, subtag, weight, part, step);
        return Writer.error((Throwable)output.trap());
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String tag, String subtag, float weight) {
        return LanguageRangeWriter.write(output, http, tag, subtag, weight, null, 1);
    }
}

