/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.collections.HashTrieMap;
import swim.http.HttpWriter;

final class MediaRangeWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final String type;
    final String subtype;
    final float weight;
    final HashTrieMap<String, String> params;
    final Writer<?, ?> part;
    final int step;

    MediaRangeWriter(HttpWriter http, String type, String subtype, float weight, HashTrieMap<String, String> params, Writer<?, ?> part, int step) {
        this.http = http;
        this.type = type;
        this.subtype = subtype;
        this.weight = weight;
        this.params = params;
        this.part = part;
        this.step = step;
    }

    MediaRangeWriter(HttpWriter http, String type, String subtype, float weight, HashTrieMap<String, String> params) {
        this(http, type, subtype, weight, params, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return MediaRangeWriter.write(output, this.http, this.type, this.subtype, this.weight, this.params, this.part, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String type, String subtype, float weight, HashTrieMap<String, String> params, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? http.writeToken(output, type) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(47);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? http.writeToken(output, subtype) : part.pull(output)).isDone()) {
                part = null;
                if (weight != 1.0f) {
                    step = 4;
                } else {
                    if (params.isEmpty()) return Writer.done();
                    step = 5;
                }
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4) {
            if ((part = part == null ? http.writeQValue(output, weight) : part.pull(output)).isDone()) {
                part = null;
                if (params.isEmpty()) return Writer.done();
                step = 5;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 5) {
            if ((part = part == null ? http.writeParamMap(output, params.iterator()) : part.pull(output)).isDone()) {
                return Writer.done();
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (!output.isError()) return new MediaRangeWriter(http, type, subtype, weight, params, part, step);
        return Writer.error((Throwable)output.trap());
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, String type, String subtype, float weight, HashTrieMap<String, String> params) {
        return MediaRangeWriter.write(output, http, type, subtype, weight, params, null, 1);
    }
}

