/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class Product
extends HttpPart
implements Debug {
    final String name;
    final String version;
    final FingerTrieSeq<String> comments;
    private static int hashSeed;

    Product(String name, String version, FingerTrieSeq<String> comments) {
        this.name = name;
        this.version = version;
        this.comments = comments;
    }

    Product(String name, String version) {
        this(name, version, (FingerTrieSeq<String>)FingerTrieSeq.empty());
    }

    Product(String name) {
        this(name, null, (FingerTrieSeq<String>)FingerTrieSeq.empty());
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public FingerTrieSeq<String> comments() {
        return this.comments;
    }

    public Product comments(FingerTrieSeq<String> comments) {
        return new Product(this.name, this.version, comments);
    }

    public Product comment(String comment) {
        return new Product(this.name, this.version, (FingerTrieSeq<String>)this.comments.appended((Object)comment));
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.productWriter(this.name, this.version, this.comments.iterator());
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeProduct(output, this.name, this.version, this.comments.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Product) {
            Product that = (Product)other;
            return this.name.equals(that.name) && (this.version == null ? that.version == null : this.version.equals(that.version)) && this.comments.equals(that.comments);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Product.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)Murmur3.hash((Object)this.version)), (int)this.comments.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("Product").write(46).write("create").write(40).debug((Object)this.name);
        if (this.version != null) {
            output = output.write(", ").debug((Object)this.version);
        }
        output = output.write(41);
        for (String comment : this.comments) {
            output = output.write(46).write("comment").write(40).debug((Object)comment).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static Product create(String name, String version, FingerTrieSeq<String> comments) {
        return new Product(name, version, comments);
    }

    public static Product create(String name, String version, String ... comments) {
        return new Product(name, version, (FingerTrieSeq<String>)FingerTrieSeq.of((Object[])comments));
    }

    public static Product create(String name, String version) {
        return new Product(name, version);
    }

    public static Product create(String name) {
        return new Product(name);
    }

    public static Product parse(String string) {
        return Http.standardParser().parseProductString(string);
    }
}

