/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.Http;
import swim.http.HttpException;

final class TokenListWriter
extends Writer<Object, Object> {
    final Iterator<?> tokens;
    final String token;
    final int index;
    final int step;

    TokenListWriter(Iterator<?> tokens, String token, int index, int step) {
        this.tokens = tokens;
        this.token = token;
        this.index = index;
        this.step = step;
    }

    TokenListWriter(Iterator<?> tokens) {
        this(tokens, null, 0, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return TokenListWriter.write(output, this.tokens, this.token, this.index, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, Iterator<?> tokens, String token, int index, int step) {
        while (true) {
            if (step == 1) {
                int length;
                if (token == null) {
                    if (!tokens.hasNext()) {
                        return Writer.done();
                    }
                    token = tokens.next().toString();
                }
                if ((length = token.length()) == 0) {
                    return Writer.error((Throwable)new HttpException("empty token"));
                }
                while (index < length && output.isCont()) {
                    int c = token.codePointAt(index);
                    if (!Http.isTokenChar(c)) {
                        return Writer.error((Throwable)new HttpException("invalid token: " + token));
                    }
                    output = output.write(c);
                    index = token.offsetByCodePoints(index, 1);
                }
                if (index == length) {
                    token = null;
                    index = 0;
                    if (!tokens.hasNext()) {
                        return Writer.done();
                    }
                    step = 2;
                }
            }
            if (step == 2 && output.isCont()) {
                output = output.write(44);
                step = 3;
            }
            if (step != 3 || !output.isCont()) break;
            output = output.write(32);
            step = 1;
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new TokenListWriter(tokens, token, index, step);
    }

    static Writer<Object, Object> write(Output<?> output, Iterator<?> tokens) {
        return TokenListWriter.write(output, tokens, null, 0, 1);
    }
}

