/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.Http;
import swim.http.HttpException;

final class TokenWriter
extends Writer<Object, String> {
    final String token;
    final int index;

    TokenWriter(String token, int index) {
        this.token = token;
        this.index = index;
    }

    TokenWriter(String token) {
        this(token, 0);
    }

    public Writer<Object, String> pull(Output<?> output) {
        return TokenWriter.write(output, this.token, this.index);
    }

    static Writer<Object, String> write(Output<?> output, String token, int index) {
        int length = token.length();
        if (length == 0) {
            return Writer.error((Throwable)new HttpException("empty token"));
        }
        while (index < length && output.isCont()) {
            int c = token.codePointAt(index);
            if (Http.isTokenChar(c)) {
                output = output.write(c);
                index = token.offsetByCodePoints(index, 1);
                continue;
            }
            return Writer.error((Throwable)new HttpException("invalid token: " + token));
        }
        if (index >= length) {
            return Writer.done();
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new TokenWriter(token, index);
    }

    static Writer<Object, String> write(Output<?> output, String token) {
        return TokenWriter.write(output, token, 0);
    }
}

