/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.http.WebSocketParam;
import swim.util.Murmur3;

public final class WebSocketExtension
extends HttpPart
implements Debug {
    final String name;
    final FingerTrieSeq<WebSocketParam> params;
    private static int hashSeed;

    WebSocketExtension(String name, FingerTrieSeq<WebSocketParam> params) {
        this.name = name;
        this.params = params;
    }

    public String name() {
        return this.name;
    }

    public FingerTrieSeq<WebSocketParam> params() {
        return this.params;
    }

    public WebSocketExtension param(WebSocketParam param) {
        return new WebSocketExtension(this.name, (FingerTrieSeq<WebSocketParam>)this.params.appended((Object)param));
    }

    public WebSocketExtension param(String key, String value) {
        return this.param(WebSocketParam.create(key, value));
    }

    public WebSocketExtension param(String key) {
        return this.param(WebSocketParam.create(key));
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.webSocketExtensionWriter(this.name, this.params.iterator());
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeWebSocketExtension(output, this.name, this.params.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WebSocketExtension) {
            WebSocketExtension that = (WebSocketExtension)other;
            return this.name.equals(that.name) && this.params.equals(that.params);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WebSocketExtension.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)this.params.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("WebSocketExtension").write(46).write("create").write(40).debug((Object)this.name).write(41);
        for (WebSocketParam param : this.params) {
            output = output.write(46).write("param").write(40).debug((Object)param.key);
            if (!param.value.isEmpty()) {
                output = output.write(", ").debug((Object)param.value);
            }
            output = output.write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static WebSocketExtension permessageDeflate(boolean serverNoContextTakeover, boolean clientNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits) {
        FingerTrieSeq params = FingerTrieSeq.empty();
        if (serverNoContextTakeover) {
            params = params.appended((Object)WebSocketParam.serverNoContextTakeover());
        }
        if (clientNoContextTakeover) {
            params = params.appended((Object)WebSocketParam.clientNoContextTakeover());
        }
        if (serverMaxWindowBits != 15) {
            params = params.appended((Object)WebSocketParam.serverMaxWindowBits(serverMaxWindowBits));
        }
        if (clientMaxWindowBits == 0) {
            params = params.appended((Object)WebSocketParam.clientMaxWindowBits());
        } else if (clientMaxWindowBits != 15) {
            params = params.appended((Object)WebSocketParam.clientMaxWindowBits(clientMaxWindowBits));
        }
        return new WebSocketExtension("permessage-deflate", (FingerTrieSeq<WebSocketParam>)params);
    }

    public static WebSocketExtension xWebkitDeflateFrame(boolean serverNoContextTakeover, boolean clientNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits) {
        FingerTrieSeq params = FingerTrieSeq.empty();
        if (serverNoContextTakeover) {
            params = params.appended((Object)WebSocketParam.serverNoContextTakeover());
        }
        if (clientNoContextTakeover) {
            params = params.appended((Object)WebSocketParam.clientNoContextTakeover());
        }
        if (serverMaxWindowBits != 15) {
            params = params.appended((Object)WebSocketParam.serverMaxWindowBits(serverMaxWindowBits));
        }
        if (clientMaxWindowBits == 0) {
            params = params.appended((Object)WebSocketParam.clientMaxWindowBits());
        } else if (clientMaxWindowBits != 15) {
            params = params.appended((Object)WebSocketParam.clientMaxWindowBits(clientMaxWindowBits));
        }
        return new WebSocketExtension("x-webkit-deflate-frame", (FingerTrieSeq<WebSocketParam>)params);
    }

    public static WebSocketExtension create(String name, FingerTrieSeq<WebSocketParam> params) {
        return new WebSocketExtension(name, params);
    }

    public static WebSocketExtension create(String name, WebSocketParam ... params) {
        return new WebSocketExtension(name, (FingerTrieSeq<WebSocketParam>)FingerTrieSeq.of((Object[])params));
    }

    public static WebSocketExtension create(String name) {
        return new WebSocketExtension(name, (FingerTrieSeq<WebSocketParam>)FingerTrieSeq.empty());
    }

    public static WebSocketExtension parse(String string) {
        return Http.standardParser().parseWebSocketExtensionString(string);
    }
}

