/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.WebSocketExtension;
import swim.http.WebSocketParam;
import swim.util.Builder;

final class WebSocketExtensionParser
extends Parser<WebSocketExtension> {
    final HttpParser http;
    final StringBuilder nameBuilder;
    final Parser<WebSocketParam> paramParser;
    final Builder<WebSocketParam, FingerTrieSeq<WebSocketParam>> params;
    final int step;

    WebSocketExtensionParser(HttpParser http, StringBuilder nameBuilder, Parser<WebSocketParam> paramParser, Builder<WebSocketParam, FingerTrieSeq<WebSocketParam>> params, int step) {
        this.http = http;
        this.nameBuilder = nameBuilder;
        this.paramParser = paramParser;
        this.params = params;
        this.step = step;
    }

    WebSocketExtensionParser(HttpParser http) {
        this(http, null, null, null, 1);
    }

    public Parser<WebSocketExtension> feed(Input input) {
        return WebSocketExtensionParser.parse(input, this.http, this.nameBuilder, this.paramParser, this.params, this.step);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<WebSocketExtension> parse(Input input, HttpParser http, StringBuilder nameBuilder, Parser<WebSocketParam> paramParser3222, Builder<WebSocketParam, FingerTrieSeq<WebSocketParam>> params, int step) {
        block21: {
            void paramParser3222;
            int c = 0;
            if (step == 1) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"websocket extension", (Input)input));
                    input = input.step();
                    if (nameBuilder == null) {
                        nameBuilder = new StringBuilder();
                    }
                    nameBuilder.appendCodePoint(c);
                    step = 2;
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"websocket extension", (Input)input));
                }
            }
            if (step == 2) {
                while (input.isCont() && Http.isTokenChar(c = input.head())) {
                    input = input.step();
                    nameBuilder.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    step = 3;
                }
            }
            while (true) {
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 59) {
                        if (params == null) {
                            params = FingerTrieSeq.builder();
                        }
                        input = input.step();
                        step = 4;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)http.webSocketExtension(nameBuilder.toString(), (FingerTrieSeq<WebSocketParam>)(params != null ? (FingerTrieSeq)params.bind() : FingerTrieSeq.empty())));
                    }
                }
                if (step == 4) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (!input.isEmpty()) {
                        step = 5;
                    }
                }
                if (step != 5) break block21;
                if (paramParser3222 == null) {
                    Parser<WebSocketParam> paramParser3222 = http.parseWebSocketParam(input);
                } else {
                    void paramParser3222;
                    Parser paramParser3222 = paramParser3222.feed(input);
                }
                if (!paramParser3222.isDone()) break;
                params.add((Object)((WebSocketParam)paramParser3222.bind()));
                Object paramParser3222 = null;
                step = 3;
            }
            if (paramParser3222.isError()) {
                return paramParser3222.asError();
            }
        }
        if (!input.isError()) void paramParser3222;
        return new WebSocketExtensionParser(http, nameBuilder, (Parser<WebSocketParam>)paramParser3222, (Builder<WebSocketParam, FingerTrieSeq<WebSocketParam>>)params, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<WebSocketExtension> parse(Input input, HttpParser http) {
        return WebSocketExtensionParser.parse(input, http, null, null, null, 1);
    }
}

