/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class WebSocketParam
extends HttpPart
implements Debug {
    final String key;
    final String value;
    private static int hashSeed;
    private static WebSocketParam clientMaxWindowBits;
    private static WebSocketParam serverNoContextTakeover;
    private static WebSocketParam clientNoContextTakeover;

    WebSocketParam(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.webSocketParamWriter(this.key, this.value);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeWebSocketParam(output, this.key, this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WebSocketParam) {
            WebSocketParam that = (WebSocketParam)other;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WebSocketParam.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.key.hashCode()), (int)this.value.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("WebSocketParam").write(46).write("create").write(40).debug((Object)this.key);
        if (!this.value.isEmpty()) {
            output = output.write(", ").debug((Object)this.value);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static WebSocketParam serverMaxWindowBits(int maxWindowBits) {
        return new WebSocketParam("server_max_window_bits", Integer.toString(maxWindowBits));
    }

    public static WebSocketParam clientMaxWindowBits(int maxWindowBits) {
        return new WebSocketParam("client_max_window_bits", Integer.toString(maxWindowBits));
    }

    public static WebSocketParam clientMaxWindowBits() {
        if (clientMaxWindowBits == null) {
            clientMaxWindowBits = new WebSocketParam("client_max_window_bits", "");
        }
        return clientMaxWindowBits;
    }

    public static WebSocketParam serverNoContextTakeover() {
        if (serverNoContextTakeover == null) {
            serverNoContextTakeover = new WebSocketParam("server_no_context_takeover", "");
        }
        return serverNoContextTakeover;
    }

    public static WebSocketParam clientNoContextTakeover() {
        if (clientNoContextTakeover == null) {
            clientNoContextTakeover = new WebSocketParam("client_no_context_takeover", "");
        }
        return clientNoContextTakeover;
    }

    public static WebSocketParam create(String key, String value) {
        if ("".equals(value)) {
            return WebSocketParam.create(key);
        }
        return new WebSocketParam(key, value);
    }

    public static WebSocketParam create(String key) {
        if ("server_no_context_takeover".equals(key)) {
            return WebSocketParam.serverNoContextTakeover();
        }
        if ("client_no_context_takeover".equals(key)) {
            return WebSocketParam.clientNoContextTakeover();
        }
        return new WebSocketParam(key, "");
    }

    public static WebSocketParam parse(String string) {
        return Http.standardParser().parseWebSocketParamString(string);
    }
}

