/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpCharset;
import swim.http.HttpParser;
import swim.http.header.AcceptCharsetHeader;
import swim.util.Builder;

final class AcceptCharsetHeaderParser
extends Parser<AcceptCharsetHeader> {
    final HttpParser http;
    final Parser<HttpCharset> charsetParser;
    final Builder<HttpCharset, FingerTrieSeq<HttpCharset>> charsets;
    final int step;

    AcceptCharsetHeaderParser(HttpParser http, Parser<HttpCharset> charsetParser, Builder<HttpCharset, FingerTrieSeq<HttpCharset>> charsets, int step) {
        this.http = http;
        this.charsetParser = charsetParser;
        this.charsets = charsets;
        this.step = step;
    }

    AcceptCharsetHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<AcceptCharsetHeader> feed(Input input) {
        return AcceptCharsetHeaderParser.parse(input, this.http, this.charsetParser, this.charsets, this.step);
    }

    static Parser<AcceptCharsetHeader> parse(Input input, HttpParser http, Parser<HttpCharset> charsetParser, Builder<HttpCharset, FingerTrieSeq<HttpCharset>> charsets, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((charsetParser = charsetParser == null ? http.parseCharset(input) : charsetParser.feed(input)).isDone()) {
                    if (charsets == null) {
                        charsets = FingerTrieSeq.builder();
                    }
                    charsets.add((Object)((HttpCharset)charsetParser.bind()));
                    charsetParser = null;
                    step = 2;
                } else if (charsetParser.isError()) {
                    return charsetParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)AcceptCharsetHeader.create((FingerTrieSeq<HttpCharset>)((FingerTrieSeq)charsets.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(charsetParser = charsetParser == null ? http.parseCharset(input) : charsetParser.feed(input)).isDone()) break;
                charsets.add((Object)((HttpCharset)charsetParser.bind()));
                charsetParser = null;
                step = 2;
            }
            if (charsetParser.isError()) {
                return charsetParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new AcceptCharsetHeaderParser(http, (Parser<HttpCharset>)charsetParser, (Builder<HttpCharset, FingerTrieSeq<HttpCharset>>)charsets, step);
    }

    static Parser<AcceptCharsetHeader> parse(Input input, HttpParser http) {
        return AcceptCharsetHeaderParser.parse(input, http, null, null, 1);
    }
}

