/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.ContentCoding;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.AcceptEncodingHeaderParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class AcceptEncodingHeader
extends HttpHeader {
    final FingerTrieSeq<ContentCoding> codings;
    private static int hashSeed;

    AcceptEncodingHeader(FingerTrieSeq<ContentCoding> codings) {
        this.codings = codings;
    }

    @Override
    public boolean isBlank() {
        return this.codings.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "accept-encoding";
    }

    @Override
    public String name() {
        return "Accept-Encoding";
    }

    public FingerTrieSeq<ContentCoding> codings() {
        return this.codings;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(output, this.codings.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AcceptEncodingHeader) {
            AcceptEncodingHeader that = (AcceptEncodingHeader)other;
            return this.codings.equals(that.codings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AcceptEncodingHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.codings.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("AcceptEncodingHeader").write(46).write("create").write(40);
        int n = this.codings.size();
        if (n > 0) {
            output = output.debug(this.codings.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.codings.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static AcceptEncodingHeader empty() {
        return new AcceptEncodingHeader((FingerTrieSeq<ContentCoding>)FingerTrieSeq.empty());
    }

    public static AcceptEncodingHeader create(FingerTrieSeq<ContentCoding> codings) {
        return new AcceptEncodingHeader(codings);
    }

    public static AcceptEncodingHeader create(ContentCoding ... codings) {
        return new AcceptEncodingHeader((FingerTrieSeq<ContentCoding>)FingerTrieSeq.of((Object[])codings));
    }

    public static AcceptEncodingHeader create(String ... codingStrings) {
        Builder codings = FingerTrieSeq.builder();
        int n = codingStrings.length;
        for (int i = 0; i < n; ++i) {
            codings.add((Object)ContentCoding.parse(codingStrings[i]));
        }
        return new AcceptEncodingHeader((FingerTrieSeq<ContentCoding>)((FingerTrieSeq)codings.bind()));
    }

    public static Parser<AcceptEncodingHeader> parseHeaderValue(Input input, HttpParser http) {
        return AcceptEncodingHeaderParser.parse(input, http);
    }
}

