/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.MediaRange;
import swim.http.header.AcceptHeaderParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class AcceptHeader
extends HttpHeader {
    final FingerTrieSeq<MediaRange> mediaRanges;
    private static int hashSeed;

    AcceptHeader(FingerTrieSeq<MediaRange> mediaRanges) {
        this.mediaRanges = mediaRanges;
    }

    @Override
    public String lowerCaseName() {
        return "accept";
    }

    @Override
    public String name() {
        return "Accept";
    }

    public FingerTrieSeq<MediaRange> mediaRanges() {
        return this.mediaRanges;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(output, this.mediaRanges.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AcceptHeader) {
            AcceptHeader that = (AcceptHeader)other;
            return this.mediaRanges.equals(that.mediaRanges);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AcceptHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.mediaRanges.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("AcceptHeader").write(46).write("create").write(40);
        int n = this.mediaRanges.size();
        if (n > 0) {
            output = output.debug(this.mediaRanges.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.mediaRanges.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static AcceptHeader empty() {
        return new AcceptHeader((FingerTrieSeq<MediaRange>)FingerTrieSeq.empty());
    }

    public static AcceptHeader create(FingerTrieSeq<MediaRange> mediaRanges) {
        return new AcceptHeader(mediaRanges);
    }

    public static AcceptHeader create(MediaRange ... mediaRanges) {
        return new AcceptHeader((FingerTrieSeq<MediaRange>)FingerTrieSeq.of((Object[])mediaRanges));
    }

    public static AcceptHeader create(String ... mediaRangeStrings) {
        Builder mediaRanges = FingerTrieSeq.builder();
        int n = mediaRangeStrings.length;
        for (int i = 0; i < n; ++i) {
            mediaRanges.add((Object)MediaRange.parse(mediaRangeStrings[i]));
        }
        return new AcceptHeader((FingerTrieSeq<MediaRange>)((FingerTrieSeq)mediaRanges.bind()));
    }

    public static Parser<AcceptHeader> parseHeaderValue(Input input, HttpParser http) {
        return AcceptHeaderParser.parse(input, http);
    }
}

