/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.MediaRange;
import swim.http.header.AcceptHeader;
import swim.util.Builder;

final class AcceptHeaderParser
extends Parser<AcceptHeader> {
    final HttpParser http;
    final Parser<MediaRange> mediaRangeParser;
    final Builder<MediaRange, FingerTrieSeq<MediaRange>> mediaRanges;
    final int step;

    AcceptHeaderParser(HttpParser http, Parser<MediaRange> mediaRangeParser, Builder<MediaRange, FingerTrieSeq<MediaRange>> mediaRanges, int step) {
        this.http = http;
        this.mediaRangeParser = mediaRangeParser;
        this.mediaRanges = mediaRanges;
        this.step = step;
    }

    AcceptHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<AcceptHeader> feed(Input input) {
        return AcceptHeaderParser.parse(input, this.http, this.mediaRangeParser, this.mediaRanges, this.step);
    }

    static Parser<AcceptHeader> parse(Input input, HttpParser http, Parser<MediaRange> mediaRangeParser, Builder<MediaRange, FingerTrieSeq<MediaRange>> mediaRanges, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((mediaRangeParser = mediaRangeParser == null ? http.parseMediaRange(input) : mediaRangeParser.feed(input)).isDone()) {
                    if (mediaRanges == null) {
                        mediaRanges = FingerTrieSeq.builder();
                    }
                    mediaRanges.add((Object)((MediaRange)mediaRangeParser.bind()));
                    mediaRangeParser = null;
                    step = 2;
                } else if (mediaRangeParser.isError()) {
                    return mediaRangeParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)AcceptHeader.create((FingerTrieSeq<MediaRange>)((FingerTrieSeq)mediaRanges.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(mediaRangeParser = mediaRangeParser == null ? http.parseMediaRange(input) : mediaRangeParser.feed(input)).isDone()) break;
                mediaRanges.add((Object)((MediaRange)mediaRangeParser.bind()));
                mediaRangeParser = null;
                step = 2;
            }
            if (mediaRangeParser.isError()) {
                return mediaRangeParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new AcceptHeaderParser(http, (Parser<MediaRange>)mediaRangeParser, (Builder<MediaRange, FingerTrieSeq<MediaRange>>)mediaRanges, step);
    }

    static Parser<AcceptHeader> parse(Input input, HttpParser http) {
        return AcceptHeaderParser.parse(input, http, null, null, 1);
    }
}

