/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.LanguageRange;
import swim.http.header.AcceptLanguageHeader;
import swim.util.Builder;

final class AcceptLanguageHeaderParser
extends Parser<AcceptLanguageHeader> {
    final HttpParser http;
    final Parser<LanguageRange> languageParser;
    final Builder<LanguageRange, FingerTrieSeq<LanguageRange>> languages;
    final int step;

    AcceptLanguageHeaderParser(HttpParser http, Parser<LanguageRange> languageParser, Builder<LanguageRange, FingerTrieSeq<LanguageRange>> languages, int step) {
        this.http = http;
        this.languageParser = languageParser;
        this.languages = languages;
        this.step = step;
    }

    AcceptLanguageHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<AcceptLanguageHeader> feed(Input input) {
        return AcceptLanguageHeaderParser.parse(input, this.http, this.languageParser, this.languages, this.step);
    }

    static Parser<AcceptLanguageHeader> parse(Input input, HttpParser http, Parser<LanguageRange> languageParser, Builder<LanguageRange, FingerTrieSeq<LanguageRange>> languages, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((languageParser = languageParser == null ? http.parseLanguageRange(input) : languageParser.feed(input)).isDone()) {
                    if (languages == null) {
                        languages = FingerTrieSeq.builder();
                    }
                    languages.add((Object)((LanguageRange)languageParser.bind()));
                    languageParser = null;
                    step = 2;
                } else if (languageParser.isError()) {
                    return languageParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)AcceptLanguageHeader.create((FingerTrieSeq<LanguageRange>)((FingerTrieSeq)languages.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(languageParser = languageParser == null ? http.parseLanguageRange(input) : languageParser.feed(input)).isDone()) break;
                languages.add((Object)((LanguageRange)languageParser.bind()));
                languageParser = null;
                step = 2;
            }
            if (languageParser.isError()) {
                return languageParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new AcceptLanguageHeaderParser(http, (Parser<LanguageRange>)languageParser, (Builder<LanguageRange, FingerTrieSeq<LanguageRange>>)languages, step);
    }

    static Parser<AcceptLanguageHeader> parse(Input input, HttpParser http) {
        return AcceptLanguageHeaderParser.parse(input, http, null, null, 1);
    }
}

