/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpMethod;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.AllowHeaderParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class AllowHeader
extends HttpHeader {
    final FingerTrieSeq<HttpMethod> methods;
    private static int hashSeed;

    AllowHeader(FingerTrieSeq<HttpMethod> methods) {
        this.methods = methods;
    }

    @Override
    public boolean isBlank() {
        return this.methods.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "allow";
    }

    @Override
    public String name() {
        return "Allow";
    }

    public FingerTrieSeq<HttpMethod> methods() {
        return this.methods;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(output, this.methods.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AllowHeader) {
            AllowHeader that = (AllowHeader)other;
            return this.methods.equals(that.methods);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(AllowHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.methods.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("AllowHeader").write(46).write("create").write(40);
        int n = this.methods.size();
        if (n > 0) {
            output = output.debug(this.methods.head());
            for (int i = 1; i < n; ++i) {
                output = output.debug((Object)", ").debug(this.methods.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static AllowHeader empty() {
        return new AllowHeader((FingerTrieSeq<HttpMethod>)FingerTrieSeq.empty());
    }

    public static AllowHeader create(FingerTrieSeq<HttpMethod> methods) {
        return new AllowHeader(methods);
    }

    public static AllowHeader create(HttpMethod ... methods) {
        return new AllowHeader((FingerTrieSeq<HttpMethod>)FingerTrieSeq.of((Object[])methods));
    }

    public static AllowHeader create(String ... methodStrings) {
        Builder methods = FingerTrieSeq.builder();
        int n = methodStrings.length;
        for (int i = 0; i < n; ++i) {
            methods.add((Object)HttpMethod.parseHttp(methodStrings[i]));
        }
        return new AllowHeader((FingerTrieSeq<HttpMethod>)((FingerTrieSeq)methods.bind()));
    }

    public static Parser<AllowHeader> parseHeaderValue(Input input, HttpParser http) {
        return AllowHeaderParser.parse(input, http);
    }
}

