/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpMethod;
import swim.http.HttpParser;
import swim.http.header.AllowHeader;
import swim.util.Builder;

final class AllowHeaderParser
extends Parser<AllowHeader> {
    final HttpParser http;
    final Parser<HttpMethod> methodParser;
    final Builder<HttpMethod, FingerTrieSeq<HttpMethod>> methods;
    final int step;

    AllowHeaderParser(HttpParser http, Parser<HttpMethod> methodParser, Builder<HttpMethod, FingerTrieSeq<HttpMethod>> methods, int step) {
        this.http = http;
        this.methodParser = methodParser;
        this.methods = methods;
        this.step = step;
    }

    AllowHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<AllowHeader> feed(Input input) {
        return AllowHeaderParser.parse(input, this.http, this.methodParser, this.methods, this.step);
    }

    static Parser<AllowHeader> parse(Input input, HttpParser http, Parser<HttpMethod> methodParser, Builder<HttpMethod, FingerTrieSeq<HttpMethod>> methods, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((methodParser = methodParser == null ? http.parseMethod(input) : methodParser.feed(input)).isDone()) {
                    if (methods == null) {
                        methods = FingerTrieSeq.builder();
                    }
                    methods.add((Object)((HttpMethod)methodParser.bind()));
                    methodParser = null;
                    step = 2;
                } else if (methodParser.isError()) {
                    return methodParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)AllowHeader.create((FingerTrieSeq<HttpMethod>)((FingerTrieSeq)methods.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(methodParser = methodParser == null ? http.parseMethod(input) : methodParser.feed(input)).isDone()) break;
                methods.add((Object)((HttpMethod)methodParser.bind()));
                methodParser = null;
                step = 2;
            }
            if (methodParser.isError()) {
                return methodParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new AllowHeaderParser(http, (Parser<HttpMethod>)methodParser, (Builder<HttpMethod, FingerTrieSeq<HttpMethod>>)methods, step);
    }

    static Parser<AllowHeader> parse(Input input, HttpParser http) {
        return AllowHeaderParser.parse(input, http, null, null, 1);
    }
}

