/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.ContentEncodingHeaderParser;
import swim.util.Murmur3;

public final class ContentEncodingHeader
extends HttpHeader {
    final FingerTrieSeq<String> codings;
    private static int hashSeed;

    ContentEncodingHeader(FingerTrieSeq<String> codings) {
        this.codings = codings;
    }

    @Override
    public boolean isBlank() {
        return this.codings.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "content-encoding";
    }

    @Override
    public String name() {
        return "Content-Encoding";
    }

    public FingerTrieSeq<String> codings() {
        return this.codings;
    }

    public boolean contains(String coding) {
        FingerTrieSeq<String> codings = this.codings;
        int n = codings.size();
        for (int i = 0; i < n; ++i) {
            if (!coding.equalsIgnoreCase((String)codings.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeTokenList(output, this.codings.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ContentEncodingHeader) {
            ContentEncodingHeader that = (ContentEncodingHeader)other;
            return this.codings.equals(that.codings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ContentEncodingHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.codings.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ContentEncodingHeader").write(46).write("create").write(40);
        int n = this.codings.size();
        if (n > 0) {
            output = output.debug(this.codings.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.codings.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static ContentEncodingHeader empty() {
        return new ContentEncodingHeader((FingerTrieSeq<String>)FingerTrieSeq.empty());
    }

    public static ContentEncodingHeader create(FingerTrieSeq<String> codings) {
        return new ContentEncodingHeader(codings);
    }

    public static ContentEncodingHeader create(String ... codings) {
        return new ContentEncodingHeader((FingerTrieSeq<String>)FingerTrieSeq.of((Object[])codings));
    }

    public static Parser<ContentEncodingHeader> parseHeaderValue(Input input, HttpParser http) {
        return ContentEncodingHeaderParser.parse(input, http);
    }
}

