/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.ContentLengthHeader;

final class ContentLengthHeaderParser
extends Parser<ContentLengthHeader> {
    final long length;
    final int step;

    ContentLengthHeaderParser(long length, int step) {
        this.length = length;
        this.step = step;
    }

    ContentLengthHeaderParser() {
        this(0L, 1);
    }

    public Parser<ContentLengthHeader> feed(Input input) {
        return ContentLengthHeaderParser.parse(input, this.length, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<ContentLengthHeader> parse(Input input, long length, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Base10.isDigit((int)c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
                input = input.step();
                length = Base10.decodeDigit((int)c);
                step = 2;
            } else if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"digit", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Base10.isDigit((int)(c = input.head()))) {
                input = input.step();
                if ((length = 10L * length + (long)Base10.decodeDigit((int)c)) >= 0L) continue;
                return Parser.error((Diagnostic)Diagnostic.message((String)"content length overflow", (Input)input));
            }
            if (!input.isEmpty()) {
                return Parser.done((Object)ContentLengthHeader.create(length));
            }
        }
        if (!input.isError()) return new ContentLengthHeaderParser(length, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<ContentLengthHeader> parse(Input input) {
        return ContentLengthHeaderParser.parse(input, 0L, 1);
    }
}

