/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.ExpectHeaderParser;
import swim.util.Murmur3;

public final class ExpectHeader
extends HttpHeader {
    final String value;
    private static int hashSeed;

    ExpectHeader(String value) {
        this.value = value;
    }

    @Override
    public boolean isBlank() {
        return this.value.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "expect";
    }

    @Override
    public String name() {
        return "Expect";
    }

    @Override
    public String value() {
        return this.value;
    }

    public boolean is100Continue() {
        return "100-continue".equals(this.value);
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writePhrase(output, this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ExpectHeader) {
            ExpectHeader that = (ExpectHeader)other;
            return this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ExpectHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.value.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ExpectHeader").write(46).write("create").write(40).debug((Object)this.value).write(41);
        return output;
    }

    public static ExpectHeader create(String value) {
        return new ExpectHeader(value);
    }

    public static Parser<ExpectHeader> parseHeaderValue(Input input, HttpParser http) {
        return ExpectHeaderParser.parse(input);
    }
}

