/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.HostHeader;
import swim.uri.Uri;
import swim.uri.UriHost;
import swim.uri.UriPort;

final class HostHeaderParser
extends Parser<HostHeader> {
    final Parser<UriHost> hostParser;
    final Parser<UriPort> portParser;
    final int step;

    HostHeaderParser(Parser<UriHost> hostParser, Parser<UriPort> portParser, int step) {
        this.hostParser = hostParser;
        this.portParser = portParser;
        this.step = step;
    }

    HostHeaderParser() {
        this(null, null, 1);
    }

    public Parser<HostHeader> feed(Input input) {
        return HostHeaderParser.parse(input, this.hostParser, this.portParser, this.step);
    }

    static Parser<HostHeader> parse(Input input, Parser<UriHost> hostParser, Parser<UriPort> portParser, int step) {
        if (step == 1) {
            if ((hostParser = hostParser == null ? Uri.standardParser().parseHost(input) : hostParser.feed(input)).isDone()) {
                step = 2;
            } else if (hostParser.isError()) {
                return hostParser.asError();
            }
        }
        if (step == 2) {
            if (input.isCont() && input.head() == 58) {
                input = input.step();
                step = 3;
            } else if (!input.isEmpty()) {
                return Parser.done((Object)HostHeader.create((UriHost)hostParser.bind()));
            }
        }
        if (step == 3) {
            if ((portParser = portParser == null ? Uri.standardParser().parsePort(input) : portParser.feed(input)).isDone()) {
                return Parser.done((Object)HostHeader.create((UriHost)hostParser.bind(), (UriPort)portParser.bind()));
            }
            if (portParser.isError()) {
                return portParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new HostHeaderParser((Parser<UriHost>)hostParser, (Parser<UriPort>)portParser, step);
    }

    static Parser<HostHeader> parse(Input input) {
        return HostHeaderParser.parse(input, null, null, 1);
    }
}

