/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base10;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.MaxForwardsHeaderParser;
import swim.util.Murmur3;

public final class MaxForwardsHeader
extends HttpHeader {
    final int count;
    private static int hashSeed;

    MaxForwardsHeader(int count) {
        this.count = count;
    }

    @Override
    public String lowerCaseName() {
        return "max-forwards";
    }

    @Override
    public String name() {
        return "Max-Forwards";
    }

    public int count() {
        return this.count;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return Base10.writeInt(output, (int)this.count);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MaxForwardsHeader) {
            MaxForwardsHeader that = (MaxForwardsHeader)other;
            return this.count == that.count;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MaxForwardsHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.count));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MaxForwardsHeader").write(46).write("create").write(40).debug((Object)this.count).write(41);
        return output;
    }

    public static MaxForwardsHeader create(int count) {
        if (count < 0) {
            throw new IllegalArgumentException(Integer.toString(count));
        }
        return new MaxForwardsHeader(count);
    }

    public static Parser<MaxForwardsHeader> parseHeaderValue(Input input, HttpParser http) {
        return MaxForwardsHeaderParser.parse(input);
    }
}

