/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.OriginHeaderParser;
import swim.http.header.OriginHeaderWriter;
import swim.uri.Uri;
import swim.util.Builder;
import swim.util.Murmur3;

public final class OriginHeader
extends HttpHeader {
    final FingerTrieSeq<Uri> origins;
    private static int hashSeed;
    private static OriginHeader empty;

    OriginHeader(FingerTrieSeq<Uri> origins) {
        this.origins = origins;
    }

    @Override
    public String lowerCaseName() {
        return "origin";
    }

    @Override
    public String name() {
        return "Origin";
    }

    public FingerTrieSeq<Uri> origins() {
        return this.origins;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        if (this.origins.isEmpty()) {
            return Unicode.writeString(output, (Object)"null");
        }
        return OriginHeaderWriter.write(output, this.origins.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OriginHeader) {
            OriginHeader that = (OriginHeader)other;
            return this.origins.equals(that.origins);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(OriginHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.origins.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("OriginHeader").write(46);
        int n = this.origins.size();
        if (n > 0) {
            output = output.write("create").write(40).debug((Object)((Uri)this.origins.head()).toString());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").write(((Uri)this.origins.get(i)).toString());
            }
        } else {
            output = output.write("empty").write(40);
        }
        output = output.write(41);
        return output;
    }

    public static OriginHeader empty() {
        if (empty == null) {
            empty = new OriginHeader((FingerTrieSeq<Uri>)FingerTrieSeq.empty());
        }
        return empty;
    }

    public static OriginHeader create(FingerTrieSeq<Uri> origins) {
        if (origins.isEmpty()) {
            return OriginHeader.empty();
        }
        return new OriginHeader(origins);
    }

    public static OriginHeader create(Uri ... origins) {
        if (origins.length == 0) {
            return OriginHeader.empty();
        }
        return new OriginHeader((FingerTrieSeq<Uri>)FingerTrieSeq.of((Object[])origins));
    }

    public static OriginHeader create(String ... originStrings) {
        if (originStrings.length == 0) {
            return OriginHeader.empty();
        }
        Builder origins = FingerTrieSeq.builder();
        int n = originStrings.length;
        for (int i = 0; i < n; ++i) {
            origins.add((Object)Uri.parse((String)originStrings[i]));
        }
        return new OriginHeader((FingerTrieSeq<Uri>)((FingerTrieSeq)origins.bind()));
    }

    public static Parser<OriginHeader> parseHeaderValue(Input input, HttpParser http) {
        return OriginHeaderParser.parse(input);
    }
}

