/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.header.OriginHeader;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriHost;
import swim.uri.UriPort;
import swim.uri.UriScheme;
import swim.util.Builder;

final class OriginHeaderParser
extends Parser<OriginHeader> {
    final Parser<UriScheme> schemeParser;
    final Parser<UriHost> hostParser;
    final Parser<UriPort> portParser;
    final Builder<Uri, FingerTrieSeq<Uri>> origins;
    final int step;

    OriginHeaderParser(Parser<UriScheme> schemeParser, Parser<UriHost> hostParser, Parser<UriPort> portParser, Builder<Uri, FingerTrieSeq<Uri>> origins, int step) {
        this.schemeParser = schemeParser;
        this.hostParser = hostParser;
        this.portParser = portParser;
        this.origins = origins;
        this.step = step;
    }

    OriginHeaderParser() {
        this(null, null, null, null, 1);
    }

    public Parser<OriginHeader> feed(Input input) {
        return OriginHeaderParser.parse(input, this.schemeParser, this.hostParser, this.portParser, this.origins, this.step);
    }

    static Parser<OriginHeader> parse(Input input, Parser<UriScheme> schemeParser, Parser<UriHost> hostParser, Parser<UriPort> portParser, Builder<Uri, FingerTrieSeq<Uri>> origins, int step) {
        block32: {
            while (true) {
                if (step == 1) {
                    if ((schemeParser = schemeParser == null ? Uri.standardParser().parseScheme(input) : schemeParser.feed(input)).isDone()) {
                        if (input.isCont() && input.head() == 58) {
                            input = input.step();
                            step = 2;
                        } else if (!input.isEmpty()) {
                            if (origins == null && "null".equals(((UriScheme)schemeParser.bind()).name())) {
                                return Parser.done((Object)OriginHeader.empty());
                            }
                            return Parser.error((Diagnostic)Diagnostic.expected((int)58, (Input)input));
                        }
                    } else if (schemeParser.isError()) {
                        return schemeParser.asError();
                    }
                }
                if (step == 2) {
                    if (input.isCont() && input.head() == 47) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
                    }
                }
                if (step == 3) {
                    if (input.isCont() && input.head() == 47) {
                        input = input.step();
                        step = 4;
                    } else if (!input.isEmpty()) {
                        return Parser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
                    }
                }
                if (step == 4) {
                    if ((hostParser = hostParser == null ? Uri.standardParser().parseHost(input) : hostParser.feed(input)).isDone()) {
                        if (input.isCont() && input.head() == 58) {
                            input = input.step();
                            step = 5;
                        } else if (!input.isEmpty()) {
                            if (origins == null) {
                                origins = FingerTrieSeq.builder();
                            }
                            origins.add((Object)Uri.create((UriScheme)((UriScheme)schemeParser.bind()), (UriAuthority)UriAuthority.create((UriHost)((UriHost)hostParser.bind()))));
                            schemeParser = null;
                            hostParser = null;
                            step = 6;
                        }
                    } else if (hostParser.isError()) {
                        return hostParser.asError();
                    }
                }
                if (step == 5) {
                    if ((portParser = portParser == null ? Uri.standardParser().parsePort(input) : portParser.feed(input)).isDone()) {
                        if (origins == null) {
                            origins = FingerTrieSeq.builder();
                        }
                        origins.add((Object)Uri.create((UriScheme)((UriScheme)schemeParser.bind()), (UriAuthority)UriAuthority.create((UriHost)((UriHost)hostParser.bind()), (UriPort)((UriPort)portParser.bind()))));
                        schemeParser = null;
                        hostParser = null;
                        portParser = null;
                        step = 6;
                    } else if (portParser.isError()) {
                        return portParser.asError();
                    }
                }
                if (step != 6) break block32;
                if (!input.isCont() || input.head() != 32) break;
                input = input.step();
                step = 1;
            }
            if (!input.isEmpty()) {
                return Parser.done((Object)OriginHeader.create((FingerTrieSeq<Uri>)((FingerTrieSeq)origins.bind())));
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new OriginHeaderParser((Parser<UriScheme>)schemeParser, (Parser<UriHost>)hostParser, (Parser<UriPort>)portParser, (Builder<Uri, FingerTrieSeq<Uri>>)origins, step);
    }

    static Parser<OriginHeader> parse(Input input) {
        return OriginHeaderParser.parse(input, null, null, null, null, 1);
    }
}

