/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.util.Iterator;
import swim.codec.Base10;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.uri.Uri;

final class OriginHeaderWriter
extends Writer<Object, Object> {
    final Iterator<Uri> origins;
    final Uri origin;
    final Writer<?, ?> part;
    final int step;

    OriginHeaderWriter(Iterator<Uri> origins, Uri origin, Writer<?, ?> part, int step) {
        this.origins = origins;
        this.origin = origin;
        this.part = part;
        this.step = step;
    }

    OriginHeaderWriter(Iterator<Uri> origins) {
        this(origins, null, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return OriginHeaderWriter.write(output, this.origins, this.origin, this.part, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Writer<Object, Object> write(Output<?> output, Iterator<Uri> origins, Uri origin, Writer<?, ?> part, int step) {
        while (true) {
            if (step == 1) {
                if (part == null) {
                    if (!origins.hasNext()) {
                        return Writer.done();
                    }
                    origin = origins.next();
                    part = Unicode.writeString((Output)output, (Object)origin.scheme().toString());
                } else {
                    part = part.pull(output);
                }
                if (part.isDone()) {
                    part = null;
                    step = 2;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step == 2 && output.isCont()) {
                output = output.write(58);
                step = 3;
            }
            if (step == 3 && output.isCont()) {
                output = output.write(47);
                step = 4;
            }
            if (step == 4 && output.isCont()) {
                output = output.write(47);
                step = 5;
            }
            if (step == 5) {
                if ((part = part == null ? Unicode.writeString((Output)output, (Object)origin.host().toString()) : part.pull(output)).isDone()) {
                    part = null;
                    if (origin.port().isDefined()) {
                        step = 6;
                    } else {
                        if (!origins.hasNext()) return Writer.done();
                        origin = null;
                        step = 8;
                    }
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step == 6 && output.isCont()) {
                output = output.write(58);
                step = 7;
            }
            if (step == 7) {
                if ((part = part == null ? Base10.writeInt((Output)output, (int)origin.portNumber()) : part.pull(output)).isDone()) {
                    part = null;
                    if (!origins.hasNext()) return Writer.done();
                    origin = null;
                    step = 8;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step != 8 || !output.isCont()) break;
            output = output.write(32);
            step = 1;
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (!output.isError()) return new OriginHeaderWriter(origins, origin, part, step);
        return Writer.error((Throwable)output.trap());
    }

    public static Writer<Object, Object> write(Output<?> output, Iterator<Uri> origins) {
        return OriginHeaderWriter.write(output, origins, null, null, 1);
    }
}

