/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.RawHeaderParser;
import swim.util.Murmur3;

public final class RawHeader
extends HttpHeader {
    final String lowerCaseName;
    final String name;
    final String value;
    private static int hashSeed;

    RawHeader(String lowerCaseName, String name, String value) {
        this.lowerCaseName = lowerCaseName;
        this.name = name;
        this.value = value;
    }

    @Override
    public boolean isBlank() {
        return this.value.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return this.lowerCaseName;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeField(output, this.value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RawHeader) {
            RawHeader that = (RawHeader)other;
            return this.name.equals(that.name) && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(RawHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)this.value.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("RawHeader").write(46).write("create").write(40).debug((Object)this.name).write(", ").debug((Object)this.value).write(41);
        return output;
    }

    public static RawHeader create(String lowerCaseName, String name, String value) {
        return new RawHeader(lowerCaseName, name, value);
    }

    public static RawHeader create(String name, String value) {
        return new RawHeader(name.toLowerCase(), name, value);
    }

    public static Parser<RawHeader> parseHeaderValue(Input input, HttpParser http, String lowerCaseName, String name) {
        return RawHeaderParser.parse(input, lowerCaseName, name);
    }
}

