/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.header.SecWebSocketAcceptHeader;

final class SecWebSocketAcceptHeaderParser
extends Parser<SecWebSocketAcceptHeader> {
    final Parser<byte[]> digestParser;

    SecWebSocketAcceptHeaderParser(Parser<byte[]> digestParser) {
        this.digestParser = digestParser;
    }

    SecWebSocketAcceptHeaderParser() {
        this(null);
    }

    public Parser<SecWebSocketAcceptHeader> feed(Input input) {
        return SecWebSocketAcceptHeaderParser.parse(input, this.digestParser);
    }

    static Parser<SecWebSocketAcceptHeader> parse(Input input, Parser<byte[]> digestParser) {
        if ((digestParser = digestParser == null ? Base64.standard().parseByteArray(input) : digestParser.feed(input)).isDone()) {
            byte[] data = (byte[])digestParser.bind();
            if (data.length != 0) {
                return Parser.done((Object)SecWebSocketAcceptHeader.create(data));
            }
            return Parser.error((Diagnostic)Diagnostic.expected((String)"base64 digest", (Input)input));
        }
        if (digestParser.isError()) {
            return digestParser.asError();
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new SecWebSocketAcceptHeaderParser((Parser<byte[]>)digestParser);
    }

    static Parser<SecWebSocketAcceptHeader> parse(Input input) {
        return SecWebSocketAcceptHeaderParser.parse(input, null);
    }
}

