/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.Product;
import swim.http.header.ServerHeaderParser;
import swim.http.header.ServerHeaderWriter;
import swim.util.Builder;
import swim.util.Murmur3;

public final class ServerHeader
extends HttpHeader {
    final FingerTrieSeq<Product> products;
    private static int hashSeed;

    ServerHeader(FingerTrieSeq<Product> products) {
        this.products = products;
    }

    @Override
    public String lowerCaseName() {
        return "server";
    }

    @Override
    public String name() {
        return "Server";
    }

    public FingerTrieSeq<Product> products() {
        return this.products;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return ServerHeaderWriter.write(output, http, this.products.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServerHeader) {
            ServerHeader that = (ServerHeader)other;
            return this.products.equals(that.products);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ServerHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.products.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ServerHeader").write(46).write("create").write(40);
        int n = this.products.size();
        if (n > 0) {
            output = output.debug(this.products.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.products.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static ServerHeader empty() {
        return new ServerHeader((FingerTrieSeq<Product>)FingerTrieSeq.empty());
    }

    public static ServerHeader create(FingerTrieSeq<Product> products) {
        return new ServerHeader(products);
    }

    public static ServerHeader create(Product ... products) {
        return new ServerHeader((FingerTrieSeq<Product>)FingerTrieSeq.of((Object[])products));
    }

    public static ServerHeader create(String ... productStrings) {
        Builder products = FingerTrieSeq.builder();
        int n = productStrings.length;
        for (int i = 0; i < n; ++i) {
            products.add((Object)Product.parse(productStrings[i]));
        }
        return new ServerHeader((FingerTrieSeq<Product>)((FingerTrieSeq)products.bind()));
    }

    public static Parser<ServerHeader> parseHeaderValue(Input input, HttpParser http) {
        return ServerHeaderParser.parse(input, http);
    }
}

