/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.Product;
import swim.http.header.ServerHeader;
import swim.util.Builder;

final class ServerHeaderParser
extends Parser<ServerHeader> {
    final HttpParser http;
    final Parser<Product> productParser;
    final Builder<Product, FingerTrieSeq<Product>> products;
    final int step;

    ServerHeaderParser(HttpParser http, Parser<Product> productParser, Builder<Product, FingerTrieSeq<Product>> products, int step) {
        this.http = http;
        this.productParser = productParser;
        this.products = products;
        this.step = step;
    }

    ServerHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<ServerHeader> feed(Input input) {
        return ServerHeaderParser.parse(input, this.http, this.productParser, this.products, this.step);
    }

    static Parser<ServerHeader> parse(Input input, HttpParser http, Parser<Product> productParser, Builder<Product, FingerTrieSeq<Product>> products, int step) {
        block13: {
            int c = 0;
            if (step == 1) {
                if ((productParser = productParser == null ? http.parseProduct(input) : productParser.feed(input)).isDone()) {
                    if (products == null) {
                        products = FingerTrieSeq.builder();
                    }
                    products.add((Object)((Product)productParser.bind()));
                    productParser = null;
                    step = 2;
                } else if (productParser.isError()) {
                    return productParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && Http.isTokenChar(c)) {
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)ServerHeader.create((FingerTrieSeq<Product>)((FingerTrieSeq)products.bind())));
                    }
                }
                if (step != 3) break block13;
                if (!(productParser = productParser == null ? http.parseProduct(input) : productParser.feed(input)).isDone()) break;
                products.add((Object)((Product)productParser.bind()));
                productParser = null;
                step = 2;
            }
            if (productParser.isError()) {
                return productParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new ServerHeaderParser(http, (Parser<Product>)productParser, (Builder<Product, FingerTrieSeq<Product>>)products, step);
    }

    static Parser<ServerHeader> parse(Input input, HttpParser http) {
        return ServerHeaderParser.parse(input, http, null, null, 1);
    }
}

