/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpWriter;
import swim.http.Product;

final class ServerHeaderWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final Iterator<Product> products;
    final Writer<?, ?> part;
    final int step;

    ServerHeaderWriter(HttpWriter http, Iterator<Product> products, Writer<?, ?> part, int step) {
        this.http = http;
        this.products = products;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return ServerHeaderWriter.write(output, this.http, this.products, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<Product> products, Writer<?, ?> part, int step) {
        while (true) {
            if (step == 1) {
                if (part == null) {
                    if (!products.hasNext()) {
                        return Writer.done();
                    }
                    part = products.next().writeHttp(output, http);
                } else {
                    part = part.pull(output);
                }
                if (part.isDone()) {
                    part = null;
                    if (!products.hasNext()) {
                        return Writer.done();
                    }
                    step = 2;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            if (step != 2 || !output.isCont()) break;
            output = output.write(32);
            step = 1;
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new ServerHeaderWriter(http, products, part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<Product> products) {
        return ServerHeaderWriter.write(output, http, products, null, 1);
    }
}

