/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.TransferCoding;
import swim.http.header.TransferEncodingHeaderParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class TransferEncodingHeader
extends HttpHeader {
    final FingerTrieSeq<TransferCoding> codings;
    private static int hashSeed;
    private static TransferEncodingHeader chunked;

    TransferEncodingHeader(FingerTrieSeq<TransferCoding> codings) {
        this.codings = codings;
    }

    @Override
    public boolean isBlank() {
        return this.codings.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "transfer-encoding";
    }

    @Override
    public String name() {
        return "Transfer-Encoding";
    }

    public FingerTrieSeq<TransferCoding> codings() {
        return this.codings;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(output, this.codings.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TransferEncodingHeader) {
            TransferEncodingHeader that = (TransferEncodingHeader)other;
            return this.codings.equals(that.codings);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(TransferEncodingHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.codings.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("TransferEncodingHeader").write(46).write("create").write(40);
        int n = this.codings.size();
        if (n != 0) {
            output = output.debug(this.codings.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.codings.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static TransferEncodingHeader chunked() {
        if (chunked == null) {
            chunked = new TransferEncodingHeader((FingerTrieSeq<TransferCoding>)FingerTrieSeq.of((Object[])new TransferCoding[]{TransferCoding.chunked()}));
        }
        return chunked;
    }

    public static TransferEncodingHeader empty() {
        return new TransferEncodingHeader((FingerTrieSeq<TransferCoding>)FingerTrieSeq.empty());
    }

    public static TransferEncodingHeader create(FingerTrieSeq<TransferCoding> codings) {
        return new TransferEncodingHeader(codings);
    }

    public static TransferEncodingHeader create(TransferCoding ... codings) {
        return TransferEncodingHeader.create((FingerTrieSeq<TransferCoding>)FingerTrieSeq.of((Object[])codings));
    }

    public static TransferEncodingHeader create(String ... codingStrings) {
        Builder codings = FingerTrieSeq.builder();
        int n = codingStrings.length;
        for (int i = 0; i < n; ++i) {
            codings.add((Object)TransferCoding.parse(codingStrings[i]));
        }
        return TransferEncodingHeader.create((FingerTrieSeq<TransferCoding>)((FingerTrieSeq)codings.bind()));
    }

    public static Parser<TransferEncodingHeader> parseHeaderValue(Input input, HttpParser http) {
        return TransferEncodingHeaderParser.parse(input, http);
    }
}

