/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.TransferCoding;
import swim.http.header.TransferEncodingHeader;
import swim.util.Builder;

final class TransferEncodingHeaderParser
extends Parser<TransferEncodingHeader> {
    final HttpParser http;
    final Parser<TransferCoding> codingParser;
    final Builder<TransferCoding, FingerTrieSeq<TransferCoding>> codings;
    final int step;

    TransferEncodingHeaderParser(HttpParser http, Parser<TransferCoding> codingParser, Builder<TransferCoding, FingerTrieSeq<TransferCoding>> codings, int step) {
        this.http = http;
        this.codingParser = codingParser;
        this.codings = codings;
        this.step = step;
    }

    TransferEncodingHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<TransferEncodingHeader> feed(Input input) {
        return TransferEncodingHeaderParser.parse(input, this.http, this.codingParser, this.codings, this.step);
    }

    static Parser<TransferEncodingHeader> parse(Input input, HttpParser http, Parser<TransferCoding> codingParser, Builder<TransferCoding, FingerTrieSeq<TransferCoding>> codings, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((codingParser = codingParser == null ? http.parseTransferCoding(input) : codingParser.feed(input)).isDone()) {
                    if (codings == null) {
                        codings = FingerTrieSeq.builder();
                    }
                    codings.add((Object)((TransferCoding)codingParser.bind()));
                    codingParser = null;
                    step = 2;
                } else if (codingParser.isError()) {
                    return codingParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)TransferEncodingHeader.create((FingerTrieSeq<TransferCoding>)((FingerTrieSeq)codings.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(codingParser = codingParser == null ? http.parseTransferCoding(input) : codingParser.feed(input)).isDone()) break;
                codings.add((Object)((TransferCoding)codingParser.bind()));
                codingParser = null;
                step = 2;
            }
            if (codingParser.isError()) {
                return codingParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new TransferEncodingHeaderParser(http, (Parser<TransferCoding>)codingParser, (Builder<TransferCoding, FingerTrieSeq<TransferCoding>>)codings, step);
    }

    static Parser<TransferEncodingHeader> parse(Input input, HttpParser http) {
        return TransferEncodingHeaderParser.parse(input, http, null, null, 1);
    }
}

