/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.UpgradeProtocol;
import swim.http.header.UpgradeHeaderParser;
import swim.util.Builder;
import swim.util.Murmur3;

public final class UpgradeHeader
extends HttpHeader {
    final FingerTrieSeq<UpgradeProtocol> protocols;
    private static int hashSeed;
    private static UpgradeHeader websocket;

    UpgradeHeader(FingerTrieSeq<UpgradeProtocol> protocols) {
        this.protocols = protocols;
    }

    @Override
    public String lowerCaseName() {
        return "upgrade";
    }

    @Override
    public String name() {
        return "Upgrade";
    }

    public FingerTrieSeq<UpgradeProtocol> protocols() {
        return this.protocols;
    }

    public boolean supports(UpgradeProtocol protocol) {
        FingerTrieSeq<UpgradeProtocol> protocols = this.protocols;
        int n = protocols.size();
        for (int i = 0; i < n; ++i) {
            if (!protocol.matches((UpgradeProtocol)protocols.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamList(output, this.protocols.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UpgradeHeader) {
            UpgradeHeader that = (UpgradeHeader)other;
            return this.protocols.equals(that.protocols);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UpgradeHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.protocols.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("UpgradeHeader").write(46).write("create").write(40);
        int n = this.protocols.size();
        if (n > 0) {
            output = output.debug(this.protocols.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.protocols.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static UpgradeHeader websocket() {
        if (websocket == null) {
            websocket = new UpgradeHeader((FingerTrieSeq<UpgradeProtocol>)FingerTrieSeq.of((Object[])new UpgradeProtocol[]{UpgradeProtocol.websocket()}));
        }
        return websocket;
    }

    public static UpgradeHeader empty() {
        return new UpgradeHeader((FingerTrieSeq<UpgradeProtocol>)FingerTrieSeq.empty());
    }

    public static UpgradeHeader create(FingerTrieSeq<UpgradeProtocol> protocols) {
        UpgradeProtocol protocol;
        if (protocols.size() == 1 && (protocol = (UpgradeProtocol)protocols.head()) == UpgradeProtocol.websocket()) {
            return UpgradeHeader.websocket();
        }
        return new UpgradeHeader(protocols);
    }

    public static UpgradeHeader create(UpgradeProtocol ... protocols) {
        return UpgradeHeader.create((FingerTrieSeq<UpgradeProtocol>)FingerTrieSeq.of((Object[])protocols));
    }

    public static UpgradeHeader create(String ... protocolStrings) {
        Builder protocols = FingerTrieSeq.builder();
        int n = protocolStrings.length;
        for (int i = 0; i < n; ++i) {
            protocols.add((Object)UpgradeProtocol.parse(protocolStrings[i]));
        }
        return UpgradeHeader.create((FingerTrieSeq<UpgradeProtocol>)((FingerTrieSeq)protocols.bind()));
    }

    public static Parser<UpgradeHeader> parseHeaderValue(Input input, HttpParser http) {
        return UpgradeHeaderParser.parse(input, http);
    }
}

