/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.UpgradeProtocol;
import swim.http.header.UpgradeHeader;
import swim.util.Builder;

final class UpgradeHeaderParser
extends Parser<UpgradeHeader> {
    final HttpParser http;
    final Parser<UpgradeProtocol> protocolParser;
    final Builder<UpgradeProtocol, FingerTrieSeq<UpgradeProtocol>> protocols;
    final int step;

    UpgradeHeaderParser(HttpParser http, Parser<UpgradeProtocol> protocolParser, Builder<UpgradeProtocol, FingerTrieSeq<UpgradeProtocol>> protocols, int step) {
        this.http = http;
        this.protocolParser = protocolParser;
        this.protocols = protocols;
        this.step = step;
    }

    UpgradeHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<UpgradeHeader> feed(Input input) {
        return UpgradeHeaderParser.parse(input, this.http, this.protocolParser, this.protocols, this.step);
    }

    static Parser<UpgradeHeader> parse(Input input, HttpParser http, Parser<UpgradeProtocol> protocolParser, Builder<UpgradeProtocol, FingerTrieSeq<UpgradeProtocol>> protocols, int step) {
        block18: {
            int c = 0;
            if (step == 1) {
                if ((protocolParser = protocolParser == null ? http.parseUpgradeProtocol(input) : protocolParser.feed(input)).isDone()) {
                    if (protocols == null) {
                        protocols = FingerTrieSeq.builder();
                    }
                    protocols.add((Object)((UpgradeProtocol)protocolParser.bind()));
                    protocolParser = null;
                    step = 2;
                } else if (protocolParser.isError()) {
                    return protocolParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && c == 44) {
                        input = input.step();
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)UpgradeHeader.create((FingerTrieSeq<UpgradeProtocol>)((FingerTrieSeq)protocols.bind())));
                    }
                }
                if (step == 3) {
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont()) {
                        step = 4;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 4) break block18;
                if (!(protocolParser = protocolParser == null ? http.parseUpgradeProtocol(input) : protocolParser.feed(input)).isDone()) break;
                protocols.add((Object)((UpgradeProtocol)protocolParser.bind()));
                protocolParser = null;
                step = 2;
            }
            if (protocolParser.isError()) {
                return protocolParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new UpgradeHeaderParser(http, (Parser<UpgradeProtocol>)protocolParser, (Builder<UpgradeProtocol, FingerTrieSeq<UpgradeProtocol>>)protocols, step);
    }

    static Parser<UpgradeHeader> parse(Input input, HttpParser http) {
        return UpgradeHeaderParser.parse(input, http, null, null, 1);
    }
}

