/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.Product;
import swim.http.header.UserAgentHeaderParser;
import swim.http.header.UserAgentHeaderWriter;
import swim.util.Builder;
import swim.util.Murmur3;

public final class UserAgentHeader
extends HttpHeader {
    final FingerTrieSeq<Product> products;
    private static int hashSeed;

    UserAgentHeader(FingerTrieSeq<Product> products) {
        this.products = products;
    }

    @Override
    public String lowerCaseName() {
        return "user-agent";
    }

    @Override
    public String name() {
        return "User-Agent";
    }

    public FingerTrieSeq<Product> products() {
        return this.products;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return UserAgentHeaderWriter.write(output, http, this.products.iterator());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UserAgentHeader) {
            UserAgentHeader that = (UserAgentHeader)other;
            return this.products.equals(that.products);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UserAgentHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.products.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("UserAgentHeader").write(46).write("create").write(40);
        int n = this.products.size();
        if (n > 0) {
            output = output.debug(this.products.head());
            for (int i = 1; i < n; ++i) {
                output = output.write(", ").debug(this.products.get(i));
            }
        }
        output = output.write(41);
        return output;
    }

    public static UserAgentHeader empty() {
        return new UserAgentHeader((FingerTrieSeq<Product>)FingerTrieSeq.empty());
    }

    public static UserAgentHeader create(FingerTrieSeq<Product> products) {
        return new UserAgentHeader(products);
    }

    public static UserAgentHeader create(Product ... products) {
        return new UserAgentHeader((FingerTrieSeq<Product>)FingerTrieSeq.of((Object[])products));
    }

    public static UserAgentHeader create(String ... productStrings) {
        Builder products = FingerTrieSeq.builder();
        int n = productStrings.length;
        for (int i = 0; i < n; ++i) {
            products.add((Object)Product.parse(productStrings[i]));
        }
        return new UserAgentHeader((FingerTrieSeq<Product>)((FingerTrieSeq)products.bind()));
    }

    public static Parser<UserAgentHeader> parseHeaderValue(Input input, HttpParser http) {
        return UserAgentHeaderParser.parse(input, http);
    }
}

