/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.ChunkExtension;
import swim.http.Http;
import swim.http.HttpParser;

final class ChunkExtensionParser
extends Parser<ChunkExtension> {
    final HttpParser http;
    final StringBuilder nameBuilder;
    final StringBuilder valueBuilder;
    final int step;

    ChunkExtensionParser(HttpParser http, StringBuilder nameBuilder, StringBuilder valueBuilder, int step) {
        this.http = http;
        this.nameBuilder = nameBuilder;
        this.valueBuilder = valueBuilder;
        this.step = step;
    }

    ChunkExtensionParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<ChunkExtension> feed(Input input) {
        return ChunkExtensionParser.parse(input, this.http, this.nameBuilder, this.valueBuilder, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<ChunkExtension> parse(Input input, HttpParser http, StringBuilder nameBuilder, StringBuilder valueBuilder, int step) {
        block38: {
            int c = 0;
            if (step == 1) {
                if (input.isCont()) {
                    c = input.head();
                    if (c != 59) return Parser.error((Diagnostic)Diagnostic.expected((String)"chunk extension", (Input)input));
                    input = input.step();
                    step = 2;
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"chunk extension", (Input)input));
                }
            }
            if (step == 2) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"chunk extension name", (Input)input));
                    input = input.step();
                    if (nameBuilder == null) {
                        nameBuilder = new StringBuilder();
                    }
                    nameBuilder.appendCodePoint(c);
                    step = 3;
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"chunk extension name", (Input)input));
                }
            }
            if (step == 3) {
                while (input.isCont() && Http.isTokenChar(c = input.head())) {
                    input = input.step();
                    nameBuilder.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    step = 4;
                }
            }
            if (step == 4) {
                if (input.isCont() && input.head() == 61) {
                    input = input.step();
                    step = 5;
                } else if (!input.isEmpty()) {
                    return Parser.done((Object)http.chunkExtension(nameBuilder.toString(), ""));
                }
            }
            if (step == 5) {
                if (input.isCont()) {
                    if (valueBuilder == null) {
                        valueBuilder = new StringBuilder();
                    }
                    if (input.head() == 34) {
                        input = input.step();
                        step = 8;
                    } else {
                        step = 6;
                    }
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                }
            }
            if (step == 6) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Http.isTokenChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"chunk extension value", (Input)input));
                    input = input.step();
                    valueBuilder.appendCodePoint(c);
                    step = 7;
                } else if (input.isDone()) {
                    return Parser.error((Diagnostic)Diagnostic.expected((String)"chunk extension value", (Input)input));
                }
            }
            if (step == 7) {
                while (input.isCont() && Http.isTokenChar(c = input.head())) {
                    input = input.step();
                    valueBuilder.appendCodePoint(c);
                }
                if (!input.isEmpty()) {
                    return Parser.done((Object)http.chunkExtension(nameBuilder.toString(), valueBuilder.toString()));
                }
            }
            while (true) {
                if (step == 8) {
                    while (input.isCont() && Http.isQuotedChar(c = input.head())) {
                        input = input.step();
                        valueBuilder.appendCodePoint(c);
                    }
                    if (input.isCont()) {
                        if (c == 34) {
                            input = input.step();
                            return Parser.done((Object)http.chunkExtension(nameBuilder.toString(), valueBuilder.toString()));
                        }
                        if (c != 92) return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                        input = input.step();
                        step = 9;
                    } else if (input.isDone()) {
                        return Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
                    }
                }
                if (step != 9) break block38;
                if (!input.isCont()) break;
                c = input.head();
                if (!Http.isEscapeChar(c)) return Parser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
                input = input.step();
                valueBuilder.appendCodePoint(c);
                step = 8;
            }
            if (input.isDone()) {
                return Parser.error((Diagnostic)Diagnostic.expected((String)"escape character", (Input)input));
            }
        }
        if (!input.isError()) return new ChunkExtensionParser(http, nameBuilder, valueBuilder, step);
        return Parser.error((Throwable)input.trap());
    }

    static Parser<ChunkExtension> parse(Input input, HttpParser http) {
        return ChunkExtensionParser.parse(input, http, null, null, 1);
    }
}

