/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class HttpMethod
extends HttpPart
implements Debug {
    final String name;
    private static int hashSeed;
    public static final HttpMethod GET;
    public static final HttpMethod HEAD;
    public static final HttpMethod POST;
    public static final HttpMethod PUT;
    public static final HttpMethod DELETE;
    public static final HttpMethod CONNECT;
    public static final HttpMethod OPTIONS;
    public static final HttpMethod TRACE;

    HttpMethod(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.methodWriter(this.name);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeMethod(output, this.name);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpMethod) {
            HttpMethod that = (HttpMethod)other;
            return this.name.equals(that.name);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpMethod.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HttpMethod").write(46);
        output = "GET".equals(this.name) || "HEAD".equals(this.name) || "POST".equals(this.name) || "PUT".equals(this.name) || "DELETE".equals(this.name) || "CONNECT".equals(this.name) || "OPTIONS".equals(this.name) || "TRACE".equals(this.name) ? output.write(this.name) : output.write("create").write(40).debug((Object)this.name).write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HttpMethod create(String name) {
        if ("GET".equals(name)) {
            return GET;
        }
        if ("HEAD".equals(name)) {
            return HEAD;
        }
        if ("POST".equals(name)) {
            return POST;
        }
        if ("PUT".equals(name)) {
            return PUT;
        }
        if ("DELETE".equals(name)) {
            return DELETE;
        }
        if ("CONNECT".equals(name)) {
            return CONNECT;
        }
        if ("OPTIONS".equals(name)) {
            return OPTIONS;
        }
        if ("TRACE".equals(name)) {
            return TRACE;
        }
        return new HttpMethod(name);
    }

    public static HttpMethod parseHttp(String string) {
        return Http.standardParser().parseMethodString(string);
    }

    static {
        GET = new HttpMethod("GET");
        HEAD = new HttpMethod("HEAD");
        POST = new HttpMethod("POST");
        PUT = new HttpMethod("PUT");
        DELETE = new HttpMethod("DELETE");
        CONNECT = new HttpMethod("CONNECT");
        OPTIONS = new HttpMethod("OPTIONS");
        TRACE = new HttpMethod("TRACE");
    }
}

