/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class HttpVersion
extends HttpPart
implements Debug {
    final int major;
    final int minor;
    private static int hashSeed;
    public static final HttpVersion HTTP_1_1;
    public static final HttpVersion HTTP_1_0;

    HttpVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.versionWriter(this.major, this.minor);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeVersion(output, this.major, this.minor);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HttpVersion) {
            HttpVersion that = (HttpVersion)other;
            return this.major == that.major && this.minor == that.minor;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HttpVersion.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.major), (int)this.minor));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HttpVersion").write(46);
        output = this.major == 1 && (this.minor == 1 || this.minor == 0) ? output.write("HTTP").write(95).debug((Object)this.major).write(95).debug((Object)this.minor) : output.write("create").write(40).debug((Object)this.major).write(", ").debug((Object)this.minor).write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static HttpVersion create(int major, int minor) {
        if (major == 1 && minor == 1) {
            return HTTP_1_1;
        }
        if (major == 1 && minor == 0) {
            return HTTP_1_0;
        }
        if (major >= 0 && minor >= 0) {
            return new HttpVersion(major, minor);
        }
        throw new IllegalArgumentException(major + ", " + minor);
    }

    public static HttpVersion parseHttp(String string) {
        return Http.standardParser().parseVersionString(string);
    }

    static {
        HTTP_1_1 = new HttpVersion(1, 1);
        HTTP_1_0 = new HttpVersion(1, 0);
    }
}

