/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Map;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.collections.HashTrieMap;
import swim.http.Http;
import swim.http.HttpPart;
import swim.http.HttpWriter;
import swim.util.Murmur3;

public final class MediaType
extends HttpPart
implements Debug {
    final String type;
    final String subtype;
    final HashTrieMap<String, String> params;
    private static int hashSeed;
    private static MediaType applicationJavascript;
    private static MediaType applicationJson;
    private static MediaType applicationOctetStream;
    private static MediaType applicationXml;
    private static MediaType applicationXRecon;
    private static MediaType imageJpeg;
    private static MediaType imagePng;
    private static MediaType imageSvgXml;
    private static MediaType textCss;
    private static MediaType textHtml;
    private static MediaType textPlain;

    MediaType(String type, String subtype, HashTrieMap<String, String> params) {
        this.type = type;
        this.subtype = subtype;
        this.params = params;
    }

    MediaType(String type, String subtype) {
        this(type, subtype, (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public boolean isApplication() {
        return "application".equalsIgnoreCase(this.type);
    }

    public boolean isAudio() {
        return "audio".equalsIgnoreCase(this.type);
    }

    public boolean isImage() {
        return "image".equalsIgnoreCase(this.type);
    }

    public boolean isMultipart() {
        return "multipart".equalsIgnoreCase(this.type);
    }

    public boolean isText() {
        return "text".equalsIgnoreCase(this.type);
    }

    public boolean isVideo() {
        return "video".equalsIgnoreCase(this.type);
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public HashTrieMap<String, String> params() {
        return this.params;
    }

    public String getParam(String key) {
        return (String)this.params.get((Object)key);
    }

    public MediaType param(String key, String value) {
        return MediaType.create(this.type, this.subtype, (HashTrieMap<String, String>)this.params.updated((Object)key, (Object)value));
    }

    @Override
    public Writer<?, ?> httpWriter(HttpWriter http) {
        return http.mediaTypeWriter(this.type, this.subtype, this.params);
    }

    @Override
    public Writer<?, ?> writeHttp(Output<?> output, HttpWriter http) {
        return http.writeMediaType(output, this.type, this.subtype, this.params);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MediaType) {
            MediaType that = (MediaType)other;
            return this.type.equals(that.type) && this.subtype.equals(that.subtype) && this.params.equals(that.params);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MediaType.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.type.hashCode()), (int)this.subtype.hashCode()), (int)this.params.hashCode()));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("MediaType").write(46).write("create").write(40).debug((Object)this.type).write(", ").write(this.subtype).write(41);
        for (Map.Entry param : this.params) {
            output = output.write(46).write("param").write(40).debug(param.getKey()).write(", ").debug(param.getValue()).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MediaType applicationJavascript() {
        if (applicationJavascript == null) {
            applicationJavascript = new MediaType("application", "javascript");
        }
        return applicationJavascript;
    }

    public static MediaType applicationJson() {
        if (applicationJson == null) {
            applicationJson = new MediaType("application", "json");
        }
        return applicationJson;
    }

    public static MediaType applicationOctetStream() {
        if (applicationOctetStream == null) {
            applicationOctetStream = new MediaType("application", "octet-stream");
        }
        return applicationOctetStream;
    }

    public static MediaType applicationXml() {
        if (applicationXml == null) {
            applicationXml = new MediaType("application", "xml");
        }
        return applicationXml;
    }

    public static MediaType applicationXRecon() {
        if (applicationXRecon == null) {
            applicationXRecon = new MediaType("application", "x-recon");
        }
        return applicationXRecon;
    }

    public static MediaType imageJpeg() {
        if (imageJpeg == null) {
            imageJpeg = new MediaType("image", "jpeg");
        }
        return imageJpeg;
    }

    public static MediaType imagePng() {
        if (imagePng == null) {
            imagePng = new MediaType("image", "png");
        }
        return imagePng;
    }

    public static MediaType imageSvgXml() {
        if (imageSvgXml == null) {
            imageSvgXml = new MediaType("image", "svg+xml");
        }
        return imageSvgXml;
    }

    public static MediaType textCss() {
        if (textCss == null) {
            textCss = new MediaType("text", "css");
        }
        return textCss;
    }

    public static MediaType textHtml() {
        if (textHtml == null) {
            textHtml = new MediaType("text", "html");
        }
        return textHtml;
    }

    public static MediaType textPlain() {
        if (textPlain == null) {
            textPlain = new MediaType("text", "plain");
        }
        return textPlain;
    }

    public static MediaType create(String type, String subtype, HashTrieMap<String, String> params) {
        if (params.isEmpty()) {
            if ("application".equals(type)) {
                if ("javascript".equals(subtype)) {
                    return MediaType.applicationJavascript();
                }
                if ("json".equals(subtype)) {
                    return MediaType.applicationJson();
                }
                if ("octet-stream".equals(subtype)) {
                    return MediaType.applicationOctetStream();
                }
                if ("xml".equals(subtype)) {
                    return MediaType.applicationXml();
                }
                if ("x-recon".equals(subtype)) {
                    return MediaType.applicationXRecon();
                }
            } else if ("image".equals(type)) {
                if ("jpeg".equals(subtype)) {
                    return MediaType.imageJpeg();
                }
                if ("png".equals(subtype)) {
                    return MediaType.imagePng();
                }
                if ("svg+xml".equals(subtype)) {
                    return MediaType.imageSvgXml();
                }
            } else if ("text".equals(type)) {
                if ("css".equals(subtype)) {
                    return MediaType.textCss();
                }
                if ("html".equals(subtype)) {
                    return MediaType.textHtml();
                }
                if ("plain".equals(subtype)) {
                    return MediaType.textPlain();
                }
            }
        }
        return new MediaType(type, subtype, params);
    }

    public static MediaType create(String type, String subtype) {
        return MediaType.create(type, subtype, (HashTrieMap<String, String>)HashTrieMap.empty());
    }

    public static MediaType parse(String string) {
        return Http.standardParser().parseMediaTypeString(string);
    }

    public static MediaType forPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.endsWith(".js")) {
            return MediaType.applicationJavascript();
        }
        if (path.endsWith(".json")) {
            return MediaType.applicationJson();
        }
        if (path.endsWith(".xml")) {
            return MediaType.applicationXml();
        }
        if (path.endsWith(".recon")) {
            return MediaType.applicationXRecon();
        }
        if (path.endsWith(".jpeg") || path.endsWith(".jpg")) {
            return MediaType.imageJpeg();
        }
        if (path.endsWith(".png")) {
            return MediaType.imagePng();
        }
        if (path.endsWith(".svg")) {
            return MediaType.imageSvgXml();
        }
        if (path.endsWith(".css")) {
            return MediaType.textCss();
        }
        if (path.endsWith(".html")) {
            return MediaType.textHtml();
        }
        if (path.endsWith(".txt")) {
            return MediaType.textPlain();
        }
        return null;
    }
}

