/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.HttpPart;
import swim.http.HttpWriter;

final class ParamListWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final Iterator<? extends HttpPart> params;
    final Writer<?, ?> paramWriter;
    final int step;
    final char separator;

    ParamListWriter(HttpWriter http, Iterator<? extends HttpPart> params, char separator, Writer<?, ?> paramWriter, int step) {
        this.http = http;
        this.params = params;
        this.paramWriter = paramWriter;
        this.step = step;
        this.separator = separator;
    }

    ParamListWriter(HttpWriter http, Iterator<? extends HttpPart> params, char separator) {
        this(http, params, separator, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return ParamListWriter.write(output, this.http, this.params, this.separator, this.paramWriter, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<? extends HttpPart> params, char separator, Writer<?, ?> paramWriter, int step) {
        while (true) {
            if (step == 1) {
                if (paramWriter == null) {
                    if (!params.hasNext()) {
                        return Writer.done();
                    }
                    paramWriter = params.next().writeHttp(output, http);
                } else {
                    paramWriter = paramWriter.pull(output);
                }
                if (paramWriter.isDone()) {
                    paramWriter = null;
                    if (!params.hasNext()) {
                        return Writer.done();
                    }
                    step = 2;
                } else if (paramWriter.isError()) {
                    return paramWriter.asError();
                }
            }
            if (step == 2 && output.isCont()) {
                output = output.write((int)separator);
                step = 3;
            }
            if (step != 3 || !output.isCont()) break;
            output = output.write(32);
            step = 1;
        }
        if (output.isDone()) {
            return Writer.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error((Throwable)output.trap());
        }
        return new ParamListWriter(http, params, separator, paramWriter, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, Iterator<? extends HttpPart> params, char separator) {
        return ParamListWriter.write(output, http, params, separator, null, 1);
    }
}

