/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Parser;
import swim.http.HttpParser;
import swim.http.MediaType;
import swim.http.header.ContentTypeHeader;

final class ContentTypeHeaderParser
extends Parser<ContentTypeHeader> {
    final HttpParser http;
    final Parser<MediaType> mediaTypeParser;

    ContentTypeHeaderParser(HttpParser http, Parser<MediaType> mediaTypeParser) {
        this.http = http;
        this.mediaTypeParser = mediaTypeParser;
    }

    ContentTypeHeaderParser(HttpParser http) {
        this(http, null);
    }

    public Parser<ContentTypeHeader> feed(Input input) {
        return ContentTypeHeaderParser.parse(input, this.http, this.mediaTypeParser);
    }

    static Parser<ContentTypeHeader> parse(Input input, HttpParser http, Parser<MediaType> mediaTypeParser) {
        if ((mediaTypeParser = mediaTypeParser == null ? http.parseMediaType(input) : mediaTypeParser.feed(input)).isDone()) {
            return Parser.done((Object)ContentTypeHeader.create((MediaType)mediaTypeParser.bind()));
        }
        if (mediaTypeParser.isError()) {
            return mediaTypeParser.asError();
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new ContentTypeHeaderParser(http, (Parser<MediaType>)mediaTypeParser);
    }

    static Parser<ContentTypeHeader> parse(Input input, HttpParser http) {
        return ContentTypeHeaderParser.parse(input, http, null);
    }
}

