/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.HashTrieMap;
import swim.http.Cookie;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.CookieHeaderParser;
import swim.util.Murmur3;

public class CookieHeader
extends HttpHeader {
    final HashTrieMap<String, Cookie> cookies;
    private static int hashSeed;

    CookieHeader(HashTrieMap<String, Cookie> cookies) {
        this.cookies = cookies;
    }

    @Override
    public boolean isBlank() {
        return this.cookies.isEmpty();
    }

    @Override
    public String lowerCaseName() {
        return "cookie";
    }

    @Override
    public String name() {
        return "Cookie";
    }

    public HashTrieMap<String, Cookie> cookies() {
        return this.cookies;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return http.writeParamListWithSeparator(output, this.cookies.values().iterator(), ';');
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CookieHeader) {
            CookieHeader that = (CookieHeader)other;
            return this.cookies.equals(that.cookies);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(CookieHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.cookies.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("CookieHeader").write(46).write("create").write(40);
        for (Cookie cookie : this.cookies.values()) {
            output = output.write(", ").debug((Object)cookie);
        }
        output = output.write(41);
        return output;
    }

    public static CookieHeader empty() {
        return new CookieHeader((HashTrieMap<String, Cookie>)HashTrieMap.empty());
    }

    public static CookieHeader create(HashTrieMap<String, Cookie> cookies) {
        return new CookieHeader(cookies);
    }

    public static CookieHeader create(Cookie ... cookies) {
        HashTrieMap cookieMap = HashTrieMap.empty();
        for (Cookie cookie : cookies) {
            cookieMap = cookieMap.updated((Object)cookie.getName(), (Object)cookie);
        }
        return new CookieHeader((HashTrieMap<String, Cookie>)cookieMap);
    }

    public static CookieHeader create(String ... cookiesString) {
        HashTrieMap cookieMap = HashTrieMap.empty();
        for (String cookieString : cookiesString) {
            Cookie cookie = Cookie.parse(cookieString);
            cookieMap = cookieMap.updated((Object)cookie.getName(), (Object)cookie);
        }
        return new CookieHeader((HashTrieMap<String, Cookie>)cookieMap);
    }

    public static Parser<CookieHeader> parseHeaderValue(Input input, HttpParser http) {
        return CookieHeaderParser.parse(input, http);
    }
}

