/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Input;
import swim.codec.Parser;
import swim.collections.HashTrieMap;
import swim.http.Cookie;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.header.CookieHeader;

public class CookieHeaderParser
extends Parser<CookieHeader> {
    final HttpParser http;
    final Parser<Cookie> cookiesParser;
    final HashTrieMap<String, Cookie> cookies;
    final int step;

    CookieHeaderParser(HttpParser http, Parser<Cookie> cookiesParser, HashTrieMap<String, Cookie> cookies, int step) {
        this.http = http;
        this.cookiesParser = cookiesParser;
        this.cookies = cookies;
        this.step = step;
    }

    CookieHeaderParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<CookieHeader> feed(Input input) {
        return CookieHeaderParser.parse(input, this.http, this.cookiesParser, this.cookies, this.step);
    }

    static Parser<CookieHeader> parse(Input input, HttpParser http, Parser<Cookie> cookieParser, HashTrieMap<String, Cookie> cookies, int step) {
        block14: {
            Cookie cookie;
            int c = 0;
            if (step == 1) {
                if ((cookieParser = cookieParser == null ? http.parseCookie(input) : cookieParser.feed(input)).isDone()) {
                    if (cookies == null) {
                        cookies = HashTrieMap.empty();
                    }
                    cookie = (Cookie)cookieParser.bind();
                    cookies = cookies.updated((Object)cookie.getName(), (Object)cookie);
                    cookieParser = null;
                    step = 2;
                } else if (cookieParser.isError()) {
                    return cookieParser.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    if (input.isCont() && (c = input.head()) == 59) {
                        input = input.step();
                    }
                    while (input.isCont() && Http.isSpace(c = input.head())) {
                        input = input.step();
                    }
                    if (input.isCont() && Http.isVisibleChar(c)) {
                        step = 3;
                    } else if (!input.isEmpty()) {
                        return Parser.done((Object)CookieHeader.create((HashTrieMap<String, Cookie>)cookies));
                    }
                }
                if (step != 3) break block14;
                if (!(cookieParser = cookieParser == null ? http.parseCookie(input) : cookieParser.feed(input)).isDone()) break;
                cookie = (Cookie)cookieParser.bind();
                cookies = cookies.updated((Object)cookie.getName(), (Object)cookie);
                cookieParser = null;
                step = 2;
            }
            if (cookieParser.isError()) {
                return cookieParser.asError();
            }
        }
        if (input.isError()) {
            return Parser.error((Throwable)input.trap());
        }
        return new CookieHeaderParser(http, (Parser<Cookie>)cookieParser, (HashTrieMap<String, Cookie>)cookies, step);
    }

    static Parser<CookieHeader> parse(Input input, HttpParser http) {
        return CookieHeaderParser.parse(input, http, null, null, 1);
    }
}

