/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.header.HostHeaderParser;
import swim.http.header.HostHeaderWriter;
import swim.uri.UriAuthority;
import swim.uri.UriHost;
import swim.uri.UriPort;
import swim.util.Murmur3;

public final class HostHeader
extends HttpHeader {
    final UriHost host;
    final UriPort port;
    private static int hashSeed;

    HostHeader(UriHost host, UriPort port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public String lowerCaseName() {
        return "host";
    }

    @Override
    public String name() {
        return "Host";
    }

    public UriHost getHost() {
        return this.host;
    }

    public UriPort port() {
        return this.port;
    }

    public InetSocketAddress inetSocketAddress() throws UnknownHostException {
        return new InetSocketAddress(this.host.inetAddress(), this.port.number());
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return HostHeaderWriter.write(output, this.host, this.port);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostHeader) {
            HostHeader that = (HostHeader)other;
            return this.host.equals((Object)that.host) && this.port.equals((Object)that.port);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HostHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.host.hashCode()), (int)this.port.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("HostHeader").write(46).write("create").write(40).debug((Object)this.host.toString());
        if (this.port.isDefined()) {
            output = output.write(", ").debug((Object)this.port.number());
        }
        output = output.write(41);
        return output;
    }

    public static HostHeader create(UriHost host, UriPort port) {
        return new HostHeader(host, port);
    }

    public static HostHeader create(UriHost host) {
        return new HostHeader(host, UriPort.undefined());
    }

    public static HostHeader create(UriAuthority authority) {
        return new HostHeader(authority.host(), authority.port());
    }

    public static HostHeader create(String host, int port) {
        return new HostHeader(UriHost.parse((String)host), UriPort.create((int)port));
    }

    public static HostHeader create(String host) {
        return new HostHeader(UriHost.parse((String)host), UriPort.undefined());
    }

    public static HostHeader create(InetSocketAddress address) {
        return new HostHeader(UriHost.inetAddress((InetAddress)address.getAddress()), UriPort.create((int)address.getPort()));
    }

    public static Parser<HostHeader> parseHeaderValue(Input input, HttpParser http) {
        return HostHeaderParser.parse(input);
    }
}

