/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Writer;
import swim.http.HttpHeader;
import swim.http.HttpWriter;
import swim.uri.Uri;
import swim.util.Murmur3;

public class LocationHeader
extends HttpHeader {
    final Uri url;
    private static int hashSeed;

    LocationHeader(Uri url) {
        this.url = url;
    }

    @Override
    public String lowerCaseName() {
        return "location";
    }

    @Override
    public String name() {
        return "Location";
    }

    public Uri location() {
        return this.url;
    }

    @Override
    public Writer<?, ?> writeHeaderValue(Output<?> output, HttpWriter http) {
        return Unicode.writeString(output, (Object)this.url);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LocationHeader) {
            LocationHeader that = (LocationHeader)other;
            return this.url.equals((Object)that.url);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(LocationHeader.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.url.hashCode()));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("LocationHeader").write(46).write("create").write(40).write(this.url.toString()).write(41);
        return output;
    }

    public static LocationHeader create(Uri url) {
        return new LocationHeader(url);
    }
}

